package com.testor.module.hazard.model.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import com.testor.module.hazard.model.domain.THazardConditionConfirmation;
import com.testor.module.hazard.model.domain.THazardConditionConfirmationDetails;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class THazardConditionConfirmationDTO extends THazardConditionConfirmation {

    @ApiModelProperty(value = "作业单位")
    private String workUnitName;

    @ApiModelProperty(value = "作业现场负责人")
    private String workSiteResponsibleName;

    @ApiModelProperty(value = "作业地点")
    private String workLocation;

    @ApiModelProperty(value = "监护人")
    private String guardianName;

    @Translation(type = TransConstant.DICT_ID_TO_LABEL)
    private String workLevelName;

    @ApiModelProperty(value = "安全管理部门人员名称")
    private String departmentName;

    List<THazardConditionConfirmationDetails> tHazardConditionConfirmationDetails;

}
