package com.testor.module.hire.entity.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * @author caq
 * @date 2024/8/30
 * @description 租赁库列表对象
 */
@Getter
@Setter
@Accessors(chain = true)
@ApiModel(value = "HireDepositoryListVo对象", description = "租赁库列表对象")
public class HireDepositoryListVo {
    @ApiModelProperty(value = "ID")
    private String id;

    @ApiModelProperty(value = "所属单位")
    private String orgName;

    @ApiModelProperty(value = "所属单位Code")
    private String orgCode;

    @ApiModelProperty(value = "库点全称")
    private String depositoryFullName;

    @ApiModelProperty(value = "存粮地址")
    private String depositoryAddress;

    @ApiModelProperty(value = "租赁方式code")
    private String accessLeaseMethodCode;

    @ApiModelProperty(value = "租赁方式text")
    private String accessLeaseMethodName;

    @ApiModelProperty(value = "租赁类型code")
    private String accessLeaseTypeCode;

    @ApiModelProperty(value = "租赁类型text")
    private String accessLeaseTypeName;

    @ApiModelProperty(value = "租赁仓容")
    private String accessLeaseCapacity;

    @ApiModelProperty(value = "出租方简称")
    private String lessorShortName;

    @ApiModelProperty(value = "租赁开始时间")
    private String accessHireStartTime;

    @ApiModelProperty(value = "租赁结束时间")
    private String accessHireEndTime;

    @ApiModelProperty(value = "库点状态 0启用 2停用")
    private String accessStatus;


    @ApiModelProperty(value = "每页数量" , required = true)
    private Integer limit = 10;

    @ApiModelProperty(value = "当前页数",required = true)
    private Integer page = 1;

}
