package com.testor.module.isRead.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 新闻公告已读未读公共对象 t_sys_is_read
 * 
 * @author testor-framework
 * @date 2022-06-14 15:19:21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_sys_is_read")
@ApiModel(value = "TSysIsRead对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSysIsRead extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键id
 */
  @ApiModelProperty(value = "主键id")

  @TableField("id")
  private String id;
/**
 * 用户id
 */
  @ApiModelProperty(value = "用户id")

  @TableField("user_id")
  private String userId;
/**
 * 文章id
 */
  @ApiModelProperty(value = "文章id")

  @TableField("article_id")
  private String articleId;
/**
 * 状态 0 未读 1已读
 */
  @ApiModelProperty(value = "状态 0 未读 1已读")

  @TableField("is_read")
  private String isRead;

  public static final String ID ="id";
  public static final String USER_ID ="user_id";
  public static final String ARTICLE_ID ="article_id";
  public static final String IS_READ ="is_read";

}
