package com.testor.module.lease.model.dto;

import com.testor.module.lease.model.domain.TLeaseBank;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 租赁库管理关系 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-20 10:09:54
 */

@Data
@ApiModel(value = "TLeaseBank 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TLeaseBankParam extends TLeaseBank {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "每页数量")
    private String limit;

    @ApiModelProperty(value = "当前页数")
    private String page;

    @ApiModelProperty(value = "排序字段")
    private String orderBy;

    @ApiModelProperty(value = "排序方式")
    private String orderType;

    @ApiModelProperty(value = "企业选择")
    private List<String> orgIds;

}
