package com.testor.module.partner.model.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.Date;


/**
 * 相关方资质证书对象 t_partner_certificate
 *
 * @author testor-framework
 * @date 2022-06-01 14:12:52
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_partner_certificate")
@ApiModel(value = "TPartnerCertificate对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TPartnerCertificate extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 业务id(相关方机构id/相关方人员id)
     */
    @ApiModelProperty(value = "业务id(相关方机构id/相关方人员id),新增相关方、人员时无此值则不填，修改时有此值须填")
    @TableField("biz_id")
    private String bizId;

    /**
     * 资质名称
     */
    @ApiModelProperty(value = "资质名称（编辑必填）")
    @TableField("name")
    private String name;
    /**
     * 编码
     */
    @ApiModelProperty(value = "编码（编辑必填）")
    @TableField("code")
    private String code;
    /**
     * 资质使用类型 1-单位资质证书；2-人员资质
     */
    @ApiModelProperty(value = "资质使用类型 1-单位资质证书；2-人员资质（编辑必填）", example = "1")
    @TableField("use_type")
    private Integer useType;
    /**
     * 有效期
     */
    @ApiModelProperty(value = "有效期")
    @TableField("valid_start_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validStartDate;
    /**
     * 有效期（复审日期）
     */
    @ApiModelProperty(value = "有效期（复审日期）（编辑必填）")
    @TableField("valid_end_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validEndDate;
    /**
     * 路径
     */
    @ApiModelProperty(value = "附件id")
    @TableField("ref_id")
    private String refId;
    /**
     * 资质状态（0-过期失效，1-正常）
     */
    @ApiModelProperty(value = "资质状态（0-过期失效，1-正常）编辑不用传此值")
    @TableField("state")
    private String state;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    @TableField("tenant_id")
    private String tenantId;

    @ApiModelProperty("资质类型 数据字典配置传入")
    @TableField("type")
    private String type;

    /**
     * 是否长期有效：1.是，2.否
     */
    @ApiModelProperty(value = "是否长期有效：1.是，2.否")
    @TableField("long_term")
    private String longTerm;


    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String CODE = "code";
    public static final String USETYPE = "use_type";
    public static final String TYPE = "type";
    public static final String VALID_START_DATE = "valid_start_date";
    public static final String VALID_END_DATE = "valid_end_date";
    public static final String REF_ID = "ref_id";
    public static final String STATE = "state";
    public static final String TENANT_ID = "tenant_id";
    public static final String LONG_TERM = "long_term";


}
