package com.testor.module.partner.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.Date;


/**
 * 相关方资质证书对象 t_partner_certificate
 *
 * @author testor-framework
 * @date 2022-06-01 14:12:52
 */
@Data
@ApiModel(value = "TPartnerCertificateDTO 对象", description = "")
public class TPartnerCertificateDTO extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * id
     */
    @ApiModelProperty(value = "id 新增时非必填/修改必填")
    private String id;

    /**
     * 业务id(相关方机构id/相关方人员id)
     */
    @ApiModelProperty(value = "业务id(相关方机构id/相关方人员id),新增相关方、人员时无此值则不填，修改时有此值须填")
    private String bizId;

    /**
     * 资质名称
     */
    @ApiModelProperty(value = "资质名称（编辑必填）")
    private String name;
    /**
     * 编码
     */
    @ApiModelProperty(value = "编码（编辑必填）")
    private String code;
    /**
     * 资质使用类型 1-单位资质证书；2-人员资质
     */
    @ApiModelProperty(value = "资质类型 1-单位资质证书；2-人员资质（编辑必填）", example = "1")
    private Integer useType;
    /**
     * 有效期
     */
    @ApiModelProperty(value = "有效期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validStartDate;
    /**
     * 有效期（复审日期）
     */
    @ApiModelProperty(value = "有效期（复审日期）（编辑必填）")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date validEndDate;

    /**
     * 是否长期有效：1.是，2.否
     */
    @ApiModelProperty(value = "是否长期有效：1.是，2.否")
    private String longTerm;
    /**
     * 路径
     */
    @ApiModelProperty(value = "附件id")
    private String refId;
    /**
     * 资质状态（0-过期失效，1-正常）
     */
    @ApiModelProperty(value = "资质状态（0-过期失效，1-正常）编辑不用传此值")
    private String state;

    /**
     * 0 正常 1 删除 2 停用
     */
    @ApiModelProperty(value = "0 正常 1 删除 2 停用")
    private String status;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    private String tenantId;

    /**
     * 资质类型 数据字典配置传入
     */
    @ApiModelProperty("资质类型 数据字典配置传入")
    private String type;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remarks;

}
