package com.testor.module.report.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

@Data
public class TSysSelectiveDto {
    /**
     * 主键id
     */
    private String id;
    /**
     * 关联id
     */
    private String refId;
    /**
     * 父级id
     */
    private String parentId;
    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 流程实例ID
     */
    private String processId;
    /**
     * 流程状态
     */
    private String processStatus;
    /**
     * 企业id
     */
    private String companyId;
    /**
     * 抽查人
     */
    private String selectivePerson;
    /**
     * 部门名称
     */
    private String deptName;
    /**
     * 抽查时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date checkTime;
    /**
     * 作业情况
     */
    private String workCase;
    /**
     * 存在问题
     */
    private String existIssue;
    /**
     * 抽查方式
     */
    private String pattern;
    /**
     * 抽查人员照片

     */
    private String checkPersonPhoto;
    /**
     * 存在问题照片
     */
    private String issuePhoto;
    /**
     * 值班人员
     */
    private String dutyOperator;
    /**
     * 值班人员id
     */
    private String dutyOperatorId;
    /**
     * 人员归属
     */
    private String unitBelong;
    /**
     * 企业名称
     */
    private String companyName;
    /**
     * 租户名称
     */
    private String tenantName;

    /**
     * 是否存在问题
     */
    private String isIssue;

    /**
     * 年
     */
    private String year;

    /**
     * 月
     */
    private String month;

    /**
     * 日
     */
    private String day;

    /**
     * 星期
     */
    private String week;

    /**
     * 抽查时间
     */
    private String time;

    /**
     * 备注
     */
    private String remarks;
}
