package com.testor.module.safeCheck.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 巡检任务对象 t_safe_hazard_check_task
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:59
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_hazard_check_task")
@ApiModel(value = "TSafeHazardCheckTask对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeHazardCheckTask extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId("id")
  private String id;
/**
 * 巡检计划id
 */
  @ApiModelProperty(value = "巡检计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 用户id
 */
  @ApiModelProperty(value = "用户id(排查人id)")

  @TableField("user_id")
  private String userId;
/**
 * 巡检人员id
 */
  @ApiModelProperty(value = "关联巡检人员表id")

  @TableField("people_id")
  private String peopleId;
/**
 * 排查单位id
 */
  @ApiModelProperty(value = "排查单位id")

  @TableField("org_id")
  private String orgId;
/**
 * 被排查单位id
 */
  @ApiModelProperty(value = "被排查单位id")

  @TableField("checked_org_id")
  private String checkedOrgId;
/**
 * 任务名
 */
  @ApiModelProperty(value = "任务名")

  @TableField("name")
  private String name;
/**
 * 巡检类型(关联字典表id)
 */
  @ApiModelProperty(value = "巡检类型(关联字典表id)")

  @TableField("check_type_id")
  private String checkTypeId;
/**
 * 任务开始时间
 */
  @ApiModelProperty(value = "任务开始时间")

  @TableField("start_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date startDate;
/**
 * 初始任务结束时间
 */
  @ApiModelProperty(value = "初始任务结束时间")

  @TableField("initial_end_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date initialEndDate;
/**
 * 任务结束时间(申请延期后此值会变)
 */
  @ApiModelProperty(value = "任务结束时间(申请延期后此值会变)")

  @TableField("end_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date endDate;
/**
 * 任务状态(0-未开始；1-进行中；2-待审批；3-已完成)
 */
  @ApiModelProperty(value = "任务状态(0-未开始；1-进行中；2-待审批；3-已完成)" , example = "0")

  @TableField("task_status")
  private Integer taskStatus;
/**
 * 是否逾期（0-未；1-逾）
 */
  @ApiModelProperty(value = "是否逾期（0-未；1-逾）")

  @TableField("is_overdue")
  private String isOverdue;
/**
 * 任务完成时间
 */
  @ApiModelProperty(value = "任务完成时间")

  @TableField("complete_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date completeDate;

  @ApiModelProperty(value = "流程id")
  @TableField("process_id")
  private String processId;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String USER_ID ="user_id";
  public static final String PEOPLE_ID ="people_id";
  public static final String ORG_ID ="org_id";
  public static final String CHECKED_ORG_ID ="checked_org_id";
  public static final String NAME ="name";
  public static final String CHECK_TYPE_ID ="check_type_id";
  public static final String START_DATE ="start_date";
  public static final String INITIAL_END_DATE ="initial_end_date";
  public static final String END_DATE ="end_date";
  public static final String TASK_STATUS ="task_status";
  public static final String IS_OVERDUE ="is_overdue";
  public static final String COMPLETE_DATE ="complete_date";


}
