package com.testor.module.sys.model.domain;

import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 系统配置对象 t_sys_config
 * 
 * @author testor-framework
 * @date 2024-12-24 15:44:32
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_sys_config")
@ApiModel(value = "TSysConfig对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSysConfig extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 参数主键
 */
  @ApiModelProperty(value = "参数主键")

  @TableId("config_id")
  private String configId;
/**
 * 参数名称
 */
  @ApiModelProperty(value = "参数名称")

  @TableField("config_name")
  private String configName;
/**
 * 参数键名
 */
  @ApiModelProperty(value = "参数键名")

  @TableField("config_key")
  private String configKey;
/**
 * 参数键值
 */
  @ApiModelProperty(value = "参数键值")

  @TableField("config_value")
  private String configValue;
/**
 * 系统内置（Y是 N否）
 */
  @ApiModelProperty(value = "系统内置（Y是 N否）")

  @TableField("config_type")
  private String configType;

  public static final String CONFIG_ID ="config_id";
  public static final String CONFIG_NAME ="config_name";
  public static final String CONFIG_KEY ="config_key";
  public static final String CONFIG_VALUE ="config_value";
  public static final String CONFIG_TYPE ="config_type";

  @JsonIgnore
  public String getId(){
  	return this.configId;
  }
  @JsonIgnore
  public void setId(String configId){
  	this.configId = configId;
  }

}
