package com.testor.module.train.exam.model.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 选择题答案——安全培训教育对象 t_train_exam_choice
 * 
 * @author testor-framework
 * @date 2022-07-13 15:23:01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_exam_choice")
@ApiModel(value = "TTrainExamChoice对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainExamChoice extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 选项 （A B C D）
 */
  @ApiModelProperty(value = "选项 （A B C D）")

  @TableField("options")
  private String options;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 父级ID
 */
  @ApiModelProperty(value = "父级ID")

  @TableField("parent_id")
  private String parentId;
/**
 * 关联ID
 */
  @ApiModelProperty(value = "关联ID")

  @TableField("exam_id")
  private String examId;
/**
 * 是否是正确选项
 */
  @ApiModelProperty(value = "是否是正确选项")

  @TableField("is_correct")
  private String isCorrect;
/**
 * 试题id
 */
  @ApiModelProperty(value = "试题id")

  @TableField("test_questions_id")
  private String testQuestionsId;
/**
 * 选项文本
 */
  @ApiModelProperty(value = "选项文本")

  @TableField("option_text")
  private String optionText;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 租户id
 */
  @ApiModelProperty(value = "租户id")

  @TableField("tenant_id")
  private String tenantId;

  public static final String ID ="id";
  public static final String OPTIONS ="options";
  public static final String PROCESS_STATUS ="process_status";
  public static final String PARENT_ID ="parent_id";
  public static final String EXAM_ID ="exam_id";
  public static final String IS_CORRECT ="is_correct";
  public static final String TEST_QUESTIONS_ID ="test_questions_id";
  public static final String OPTION_TEXT ="option_text";
  public static final String PROCESS_ID ="process_id";
  public static final String TENANT_ID ="tenant_id";


}
