package com.testor.module.video.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.module.video.dao.TVideoEquipmentCareDao;
import com.testor.module.video.model.domain.TVideoEquipmentCare;
import com.testor.module.video.service.TVideoEquipmentCareService;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class TVideoEquipmentCareServiceImpl extends SuperServiceImpl<TVideoEquipmentCareDao, TVideoEquipmentCare> implements TVideoEquipmentCareService {
    @Override
    public List<TVideoEquipmentCare> findByUserId(String userId) {
        return this.baseMapper.selectList(new LambdaQueryWrapper<TVideoEquipmentCare>().eq(TVideoEquipmentCare::getUserId, userId));
    }

    @Override
    public List<String> findDeviceIdsByUserId(String userId) {
        List<TVideoEquipmentCare> tVideoEquipmentCares = this.baseMapper.selectList(new LambdaQueryWrapper<TVideoEquipmentCare>().select(TVideoEquipmentCare::getDeviceId).eq(TVideoEquipmentCare::getUserId, userId).isNotNull(TVideoEquipmentCare::getDeviceId));
        List<String> ids = new ArrayList<>();
        if (!CollectionUtils.isEmpty(tVideoEquipmentCares)&& tVideoEquipmentCares.size()>0) {
            ids = tVideoEquipmentCares.stream().map(TVideoEquipmentCare::getDeviceId).collect(Collectors.toList());
        }
        return ids;
    }
}
