/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.monitor.core.instrument;

import com.tongweb.commons.monitor.core.instrument.Gauge;
import com.tongweb.commons.monitor.core.instrument.Meter;
import com.tongweb.commons.monitor.core.instrument.MeterRegistry;
import com.tongweb.commons.monitor.core.instrument.Tag;
import com.tongweb.commons.monitor.core.instrument.Tags;
import com.tongweb.commons.monitor.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;

public interface TimeGauge
extends Gauge {
    public static <T> Builder<T> builder(String name, T obj, TimeUnit fUnits, ToDoubleFunction<T> f) {
        return new Builder(name, obj, fUnits, f);
    }

    public TimeUnit baseTimeUnit();

    default public double value(TimeUnit unit) {
        return TimeUtils.convert(this.value(), this.baseTimeUnit(), unit);
    }

    public static class Builder<T> {
        private final String name;
        private final TimeUnit fUnits;
        private final ToDoubleFunction<T> f;
        private Tags tags = Tags.empty();
        private final T obj;
        private String description;

        private Builder(String name, T obj, TimeUnit fUnits, ToDoubleFunction<T> f) {
            this.name = name;
            this.obj = obj;
            this.fUnits = fUnits;
            this.f = f;
        }

        public Builder<T> tags(String ... tags) {
            return this.tags(Tags.of(tags));
        }

        public Builder<T> tags(Iterable<Tag> tags) {
            this.tags = this.tags.and(tags);
            return this;
        }

        public Builder<T> tag(String key, String value) {
            this.tags = this.tags.and(key, value);
            return this;
        }

        public Builder<T> description(String description) {
            this.description = description;
            return this;
        }

        public TimeGauge register(MeterRegistry registry) {
            return registry.more().timeGauge(new Meter.Id(this.name, this.tags, null, this.description, Meter.Type.GAUGE), this.obj, this.fUnits, this.f);
        }
    }
}

