/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.context;

import com.tongtech.tfw.backend.common.context.SpringContextRegister;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.context.ApplicationContext;

public class ContextHelper {
    private static final ApplicationContext APPLICATION_CONTEXT = SpringContextRegister.getApplicationContext();

    public static Object getObjectBean(String beanName) {
        if (APPLICATION_CONTEXT.containsBean(beanName)) {
            return APPLICATION_CONTEXT.getBean(beanName);
        }
        return null;
    }

    public static <T> T getBeanByName(String beanName) {
        Class beanType;
        if (APPLICATION_CONTEXT.containsBean(beanName) && ObjectHelper.isNotEmpty((Object)(beanType = APPLICATION_CONTEXT.getType(beanName)))) {
            return (T)APPLICATION_CONTEXT.getBean(beanName, beanType);
        }
        return null;
    }

    public static <T> T getBeanByType(Class<T> beanType) {
        return (T)APPLICATION_CONTEXT.getBean(beanType);
    }
}

