/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.core;

import com.tongweb.container.LifecycleEvent;
import com.tongweb.container.LifecycleListener;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.web.util.res.StringManager;

public class JniLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(JniLifecycleListener.class);
    protected static final StringManager sm = StringManager.getManager(JniLifecycleListener.class);
    private String libraryName = "";
    private String libraryPath = "";

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_start".equals(event.getType())) {
            if (!this.libraryName.isEmpty()) {
                System.loadLibrary(this.libraryName);
                log.info(sm.getString("jniLifecycleListener.load.name", this.libraryName));
            } else if (!this.libraryPath.isEmpty()) {
                System.load(this.libraryPath);
                log.info(sm.getString("jniLifecycleListener.load.path", this.libraryPath));
            } else {
                throw new IllegalArgumentException(sm.getString("jniLifecycleListener.missingPathOrName"));
            }
        }
    }

    public void setLibraryName(String libraryName) {
        if (!this.libraryPath.isEmpty()) {
            throw new IllegalArgumentException(sm.getString("jniLifecycleListener.bothPathAndName"));
        }
        this.libraryName = libraryName;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryPath(String libraryPath) {
        if (!this.libraryName.isEmpty()) {
            throw new IllegalArgumentException(sm.getString("jniLifecycleListener.bothPathAndName"));
        }
        this.libraryPath = libraryPath;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }
}

