/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.commons.license.utils.cipher;

import com.tongtech.commons.license.utils.cipher.MultiJDKBase64Util;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ECDSAUtil {
    private static final Logger a = Logger.getLogger(ECDSAUtil.class.getName());

    public static KeyPair generateKey() {
        Object object;
        try {
            object = KeyPairGenerator.getInstance("EC");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        Object object2 = new ECGenParameterSpec("secp256r1");
        try {
            ((KeyPairGenerator)object).initialize((AlgorithmParameterSpec)object2);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new RuntimeException(invalidAlgorithmParameterException);
        }
        object = ((KeyPairGenerator)object).generateKeyPair();
        object2 = ((KeyPair)object).getPublic();
        object = ((KeyPair)object).getPrivate();
        return new KeyPair((PublicKey)object2, (PrivateKey)object);
    }

    public static String publicKeyToString(KeyPair keyPair) {
        if (keyPair == null) {
            throw new RuntimeException("keyPair is null");
        }
        return ECDSAUtil.publicKeyToString(keyPair.getPublic());
    }

    public static String publicKeyToString(PublicKey publicKey) {
        if (publicKey == null) {
            throw new RuntimeException("publicKey is null");
        }
        return MultiJDKBase64Util.encode(publicKey.getEncoded());
    }

    public static String privateKeyToString(KeyPair keyPair) {
        if (keyPair == null) {
            throw new RuntimeException("keyPair is null");
        }
        return ECDSAUtil.privateKeyToString(keyPair.getPrivate());
    }

    public static String privateKeyToString(PrivateKey privateKey) {
        if (privateKey == null) {
            throw new RuntimeException("privateKey is null");
        }
        return MultiJDKBase64Util.encode(privateKey.getEncoded());
    }

    public static PublicKey stringToPublicKey(String object) {
        if (a.isLoggable(Level.FINE)) {
            a.log(Level.FINE, "publicKeyStr: " + (String)object);
        }
        if (object == null || ((String)object).isEmpty()) {
            throw new RuntimeException("stringToPublicKey param of publicKeyStr is null");
        }
        object = MultiJDKBase64Util.decode((String)object);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            object = new X509EncodedKeySpec((byte[])object);
            return keyFactory.generatePublic((KeySpec)object);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
    }

    public static PrivateKey stringToPrivateKey(String object) {
        if (a.isLoggable(Level.FINE)) {
            a.log(Level.FINE, "privateKeyStr: " + (String)object);
        }
        if (object == null || ((String)object).isEmpty()) {
            throw new RuntimeException("stringToPrivateKey param of privateKeyStr is null");
        }
        object = MultiJDKBase64Util.decode((String)object);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            object = new PKCS8EncodedKeySpec((byte[])object);
            return keyFactory.generatePrivate((KeySpec)object);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
    }

    public static String sign(String string, String string2) {
        return ECDSAUtil.sign(string, ECDSAUtil.stringToPrivateKey(string2));
    }

    public static String sign(String object, PrivateKey privateKey) {
        if (a.isLoggable(Level.FINE)) {
            a.log(Level.FINE, "data: " + (String)object);
        }
        if (object == null || ((String)object).isEmpty()) {
            throw new RuntimeException("sign param of data is null");
        }
        try {
            Signature signature = Signature.getInstance("SHA256withECDSA");
            signature.initSign(privateKey);
            object = ((String)object).getBytes();
            signature.update((byte[])object);
            return MultiJDKBase64Util.encode(signature.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
    }

    public static boolean verify(String string, String string2, String string3) {
        return ECDSAUtil.verify(string, string2, ECDSAUtil.stringToPublicKey(string3));
    }

    public static boolean verify(String object, String string, PublicKey publicKey) {
        if (a.isLoggable(Level.FINE)) {
            a.log(Level.FINE, "data: " + (String)object + ", signStr: " + string);
        }
        if (object == null || ((String)object).isEmpty()) {
            throw new RuntimeException("verify param of data is null");
        }
        if (string == null || string.isEmpty()) {
            throw new RuntimeException("verify param of signStr is null");
        }
        try {
            Signature signature = Signature.getInstance("SHA256withECDSA");
            signature.initVerify(publicKey);
            object = ((String)object).getBytes();
            signature.update((byte[])object);
            return signature.verify(MultiJDKBase64Util.decode(string));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
    }
}

