package com.testor.common.util.excel;

import com.alibaba.excel.annotation.ExcelProperty;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * @author rsq
 * @program zlmy_boot
 * @return
 **/
public class FetchFieldUtil {

    /** 
     * @description: 获取声明字段
     * @param: [clazz] 要提取字段的类
     * @return: {@link List< String>}
     * @author renshuaiqi
     * @date: 2023/4/3 10:13
     */ 
    public static List<String> getValidField(Class clazz){
        List<String> excludeColumns = new ArrayList<>();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; i++) {
            ExcelProperty exportColumn = fields[i].getDeclaredAnnotation(ExcelProperty.class);
            if (exportColumn == null) {
                excludeColumns.add(fields[i].getName());
            }
        }
        return excludeColumns;
    }
}
