package com.testor.module.ZLOA.sysUserOA.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 用户 (OA)对象 t_sys_user_oa
 * 
 * @author testor-framework
 * @date 2022-09-29 15:49:08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_sys_user_oa")
@ApiModel(value = "TSysUserOa对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSysUserOa extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 用户表主键
 */
  @ApiModelProperty(value = "用户表主键")

  @TableId("user_id")
  private String userId;
/**
 * 机构表主键
 */
  @ApiModelProperty(value = "机构表主键")

  @TableField("org_id")
  private String orgId;
/**
 * 登录账号
 */
  @ApiModelProperty(value = "登录账号")

  @TableField("login_name")
  private String loginName;
/**
 * 登录密码
 */
  @ApiModelProperty(value = "登录密码")

  @TableField("login_pwd")
  private String loginPwd;
/**
 * 用户昵称
 */
  @ApiModelProperty(value = "用户昵称")

  @TableField("user_name")
  private String userName;
/**
 * 用户类型，在系统内部使用0表示系统管理员，1表示不是系统内部的人员
 */
  @ApiModelProperty(value = "用户类型，在系统内部使用0表示系统管理员，1表示不是系统内部的人员")

  @TableField("user_type")
  private String userType;
/**
 * 用户头像
 */
  @ApiModelProperty(value = "用户头像")

  @TableField("photo_url")
  private String photoUrl;
/**
 * 最后登陆IP
 */
  @ApiModelProperty(value = "最后登陆IP")

  @TableField("login_ip")
  private String loginIp;
/**
 * 最后登陆时间
 */
  @ApiModelProperty(value = "最后登陆时间")

  @TableField("login_date")

  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date loginDate;
/**
 * 密码安全级别，密码安全级别（ 1弱 2一般 3安全）
 */
  @ApiModelProperty(value = "密码安全级别，密码安全级别（ 1弱 2一般 3安全）")

  @TableField("pwd_security_level")
  private String pwdSecurityLevel;
/**
 * 用户性别0男1女
 */
  @ApiModelProperty(value = "用户性别0男1女")

  @TableField("sex")
  private String sex;
/**
 * 联系地址
 */
  @ApiModelProperty(value = "联系地址")

  @TableField("address")
  private String address;
/**
 * 邮政编码
 */
  @ApiModelProperty(value = "邮政编码")

  @TableField("zip_code")
  private String zipCode;
/**
 * 电话
 */
  @ApiModelProperty(value = "电话")

  @TableField("phone_no")
  private String phoneNo;
/**
 * 传真
 */
  @ApiModelProperty(value = "传真")

  @TableField("fax")
  private String fax;
/**
 * 邮箱
 */
  @ApiModelProperty(value = "邮箱")

  @TableField("email")
  private String email;
/**
 * UKEY-USER-PID
 */
  @ApiModelProperty(value = "UKEY-USER-PID")

  @TableField("user_key_pid")
  private String userKeyPid;
/**
 * 年龄
 */
  @ApiModelProperty(value = "年龄" , example = "0")

  @TableField("age")
  private Long age;
/**
 * 部门id
 */
  @ApiModelProperty(value = "部门id")

  @TableField("dept_id")
  private String deptId;
/**
 * 主岗位id
 */
  @ApiModelProperty(value = "主岗位id")

  @TableField("post_id")
  private String postId;
/**
 * 企业名称
 */
  @ApiModelProperty(value = "企业名称")

  @TableField("org_name")
  private String orgName;
/**
 * 岗位名称
 */
  @ApiModelProperty(value = "岗位名称")

  @TableField("post_name")
  private String postName;
/**
 * 副岗位id
 */
  @ApiModelProperty(value = "副岗位id")

  @TableField("deputy_post_id")
  private String deputyPostId;

  public static final String USER_ID ="user_id";
  public static final String ORG_ID ="org_id";
  public static final String LOGIN_NAME ="login_name";
  public static final String LOGIN_PWD ="login_pwd";
  public static final String USER_NAME ="user_name";
  public static final String USER_TYPE ="user_type";
  public static final String PHOTO_URL ="photo_url";
  public static final String LOGIN_IP ="login_ip";
  public static final String LOGIN_DATE ="login_date";
  public static final String PWD_SECURITY_LEVEL ="pwd_security_level";
  public static final String SEX ="sex";
  public static final String ADDRESS ="address";
  public static final String ZIP_CODE ="zip_code";
  public static final String PHONE_NO ="phone_no";
  public static final String FAX ="fax";
  public static final String EMAIL ="email";
  public static final String USER_KEY_PID ="user_key_pid";
  public static final String AGE ="age";
  public static final String DEPT_ID ="dept_id";
  public static final String POST_ID ="post_id";
  public static final String ORG_NAME ="org_name";
  public static final String POST_NAME ="post_name";
  public static final String DEPUTY_POST_ID ="deputy_post_id";

  @JsonIgnore
  public String getId(){
  	return this.userId;
  }
  @JsonIgnore
  public void setId(String userId){
  	this.userId = userId;
  }

}
