package com.testor.module.accident.constant;

import com.testor.common.util.CodeEnum;
import lombok.Getter;

@Getter
public enum FakeType implements CodeEnum {

    WORKING_DAY("0", "工作日"),
    OFF_DAY("1", "休息日"),
    HOLIDAY("2", "节假日"),
    ;

    FakeType(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private String code;

    private String msg;

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return msg;
    }
}
