package com.testor.module.contractor.ledger.model.template;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.converters.string.StringNumberConverter;
import com.alibaba.excel.converters.string.StringStringConverter;
import com.testor.common.annotation.ExcelDictFormat;
import com.testor.common.annotation.ExcelSelected;
import com.testor.common.constant.ExcelSelectConstant;
import com.testor.common.convert.ExcelDeptConvert;
import com.testor.common.convert.ExcelDictConvert;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class ProjectTemplate {

    @ExcelProperty(value = "项目名称", index = 0)
    @NotBlank(message = "项目名称不能为空")
    private String name;

    @ExcelProperty(value = "项目级别", index = 1, converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "contractor_project_level")
    @ExcelSelected(type = ExcelSelectConstant.DICT_DATA_BY_TYPE, param = "contractor_project_level")
    @NotBlank(message = "项目级别不能为空")
    private String level;

    @ExcelProperty(value = "项目周期", index = 2, converter = ExcelDictConvert.class)
    @ExcelDictFormat(dictType = "contractor_project_cycle")
    @ExcelSelected(type = ExcelSelectConstant.DICT_DATA_BY_TYPE, param = "contractor_project_cycle")
    @NotBlank(message = "项目周期不能为空")
    private String cycle;

    @ExcelProperty(value = "项目金额（万元）", index = 3, converter = StringNumberConverter.class)
    @NotBlank(message = "项目金额不能为空")
    private String amount;

    @ExcelProperty(value = "立项时间", index = 4)
    @NotNull(message = "立项时间不能为空")
    private Date creationTime;

    @ExcelProperty(value = "项目主管部门", index = 5, converter = ExcelDeptConvert.class)
    @ExcelSelected(type = ExcelSelectConstant.DEPT_DATA_BY_ID)
    @NotBlank(message = "项目主管部门不能为空")
    private String departmentMajor;

    @ExcelProperty(value = "项目所在部门", index = 6, converter = ExcelDeptConvert.class)
    @ExcelSelected(type = ExcelSelectConstant.DEPT_DATA_BY_ID)
    @NotBlank(message = "项目所在部门不能为空")
    private String departmentBelong;

    @ExcelProperty(value = "计划开始时间", index = 7)
    @NotNull(message = "计划开始时间不能为空")
    private Date planStartTime;

    @ExcelProperty(value = "计划结束时间", index = 8)
    @NotNull(message = "计划结束时间不能为空")
    private Date planEndTime;

    @ExcelProperty(value = "项目简介", index = 9)
    private String introduction;
}
