package com.testor.module.contractor.manage.controller;

import java.util.ArrayList;
import java.util.List;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.testor.module.contractor.manage.model.domain.TContractorAllowPerson;
import com.testor.module.contractor.manage.model.vo.TContractorAllowMaterialVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorAllowMaterial;
import com.testor.module.contractor.manage.model.dto.TContractorAllowMaterialParam;
import com.testor.module.contractor.manage.model.dto.TContractorAllowMaterialDelParam;
import com.testor.module.contractor.manage.service.TContractorAllowMaterialService;

/**
 * 准入信息-物料台账关联Controller
 *
 * @author testor-framework
 * @date 2024-11-26 14:08:48
 */
@RestController
@RequestMapping("/material/material")
@Api(value = "TContractorAllowMaterial", tags = "准入信息-物料台账关联")
@Slf4j
public class TContractorAllowMaterialController extends SuperController
{
    @Autowired
    private TContractorAllowMaterialService tContractorAllowMaterialService;

    /* Generated Method*/
	@ApiOperation(value = "新增 准入信息-物料台账关联", notes = "Add TContractorAllowMaterial")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorAllowMaterial>addEntity(@RequestBody TContractorAllowMaterialParam addRequest) {
		BaseResponse<TContractorAllowMaterial> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			tContractorAllowMaterialService.remove(new LambdaQueryWrapper<TContractorAllowMaterial>().eq(TContractorAllowMaterial::getAllowId, addRequest.getAllowId()));
			List<String> ids = addRequest.getIds();
			for (String id : ids) {
				TContractorAllowMaterial data=BeanHelper.beanToBean(addRequest,  TContractorAllowMaterial.class);
				data.setId(IdHelper.getId32bit());
				data.setMaterialId(id);
				tContractorAllowMaterialService.save(data);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 准入信息-物料台账关联 ", notes = "Get TContractorAllowMaterial By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorAllowMaterial> getById(String id){
		BaseResponse<TContractorAllowMaterial> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorAllowMaterial data= tContractorAllowMaterialService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 准入信息-物料台账关联 ", notes = "Update TContractorAllowMaterial By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorAllowMaterial updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorAllowMaterial data=BeanHelper.beanToBean(updateRequest, TContractorAllowMaterial.class);
			boolean result= tContractorAllowMaterialService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 准入信息-物料台账关联 ", notes = "delete TContractorAllowMaterial By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorAllowMaterialDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorAllowMaterial data= new TContractorAllowMaterial();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorAllowMaterialService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除准入信息-物料台账关联", notes = "delete TContractorAllowMaterial by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorAllowMaterialDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorAllowMaterial> tContractorAllowMaterialList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorAllowMaterial data= new TContractorAllowMaterial();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorAllowMaterialList.add(data);
			}
			boolean result = tContractorAllowMaterialService.updateBatchById(tContractorAllowMaterialList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 准入信息-物料台账关联 分页列表", notes = "List TContractorAllowMaterial with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorAllowMaterialVo>>listEntity(TContractorAllowMaterialParam param){
		BaseResponse<BaseResponseList<TContractorAllowMaterialVo>>baseResponse=new BaseResponse<>();
		Page<TContractorAllowMaterialVo> resultList= tContractorAllowMaterialService.listEntity(param);
		BaseResponseList<TContractorAllowMaterialVo> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 准入信息-物料台账关联 列表", notes = "List TContractorAllowMaterial all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorAllowMaterial>>listAllEntity(TContractorAllowMaterialParam param){
		BaseResponse<BaseResponseList<TContractorAllowMaterial>>baseResponse=new BaseResponse<>();
		List<TContractorAllowMaterial> resultList=tContractorAllowMaterialService.listAllEntity(param);
		BaseResponseList<TContractorAllowMaterial> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

}
