package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;

import com.testor.module.contractor.ledger.model.domain.TContractorPerson;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 准入信息-人员台账关系对象 t_contractor_allow_person
 * 
 * @author testor-framework
 * @date 2024-11-26 14:08:51
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_allow_person")
@ApiModel(value = "TContractorAllowPerson对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorAllowPerson extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")

  @TableId("id")
  private String id;
/**
 * 准入id
 */
  @ApiModelProperty(value = "准入id")

  @TableField("allow_id")
  private String allowId;
/**
 * 人员id
 */
  @ApiModelProperty(value = "人员id")

  @TableField("person_id")
  private String personId;

  @TableField(exist = false)
  private TContractorPerson tContractorPerson;

/**
 * 承包商id
 */
  @ApiModelProperty(value = "承包商id")

  @TableField("contractor_id")
  private String contractorId;
/**
 * 项目id
 */
  @ApiModelProperty(value = "项目id")

  @TableField("proj_id")
  private String projId;
/**
 * 业务id(标识是一条基本信息产生的关系)
 */
  @ApiModelProperty(value = "业务id(标识是一条基本信息产生的关系)")

  @TableField("biz_id")
  private String bizId;

  /**
   * 是否上传培训记录 0否 1是
   */
  @ApiModelProperty(value = "是否上传培训记录 0否 1是")

  @TableField("is_training_record_uploaded")
  private String isTrainingRecordUploaded;

/**
 * 是否合格 0否 1是
 */
  @ApiModelProperty(value = "是否合格 0否 1是")

  @TableField("is_qualified")
  private String isQualified;
/**
 * 培训记录附件
 */
  @ApiModelProperty(value = "培训记录附件")

  @TableField("training_record")
  private String trainingRecord;

  public static final String ID ="id";
  public static final String ALLOW_ID ="allow_id";
  public static final String PERSON_ID ="person_id";
  public static final String CONTRACTOR_ID ="contractor_id";
  public static final String PROJ_ID ="proj_id";
  public static final String BIZ_ID ="biz_id";
  public static final String IS_QUALIFIED ="is_qualified";
  public static final String TRAINING_RECORD ="training_record";


}
