package com.testor.module.duty.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.module.duty.dao.TSysSelectiveDao;
import com.testor.module.duty.model.domain.TSysDuty;
import com.testor.module.duty.model.domain.TSysSelective;
import com.testor.module.duty.model.dto.TSysSelectiveDelParam;
import com.testor.module.duty.service.DutyService;
import com.testor.module.duty.service.TSysSelectiveService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.exception.BusinessException;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;

/**
 * 值班抽查Service业务层处理
 *
 * @author testor-framework
 * @date 2022-06-06 10:06:20
 */
@Service
public class TSysSelectiveServiceImpl extends SuperServiceImpl<TSysSelectiveDao, TSysSelective> implements TSysSelectiveService {
    @Autowired
    private SysOrgService sysOrgService;
    @Autowired
    private DutyService dutyService;

    @Override
    public BaseResponse<TSysSelective> add(TSysSelective addRequest) throws Exception {
        UserInfo loginUser = ContextUtils.getLoginUser();
        SysOrg sysOrg = sysOrgService.getById(loginUser.getOrgId());
        if (Objects.isNull(sysOrg)) {
            throw new BusinessException("当前登录人部门信息不存在，请联系管理员！");
        }
        BaseResponse<TSysSelective> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(addRequest)) {
            String id = IdHelper.getId32bit();
            TSysSelective data = BeanHelper.beanToBean(addRequest, TSysSelective.class);
            data.setId(id);
            data.setIsIssue("0");
            if (!"".equals(data.getExistIssue()) || !"".equals(data.getIssuePhoto())) {
                data.setIsIssue("1");
            }

            String refId = addRequest.getRefId();

            QueryWrapper<TSysDuty> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("id", refId);
            TSysDuty one = dutyService.getOne(queryWrapper);
            // 抽查单位orgId
            data.setOrgId(loginUser.getOrgId());
            //被抽查单位名称
            data.setCompanyName(one.getCompanyName());
            //被抽查单位id
            data.setCompanyId(one.getCompanyId());
            data.setCreateBy(loginUser.getUserId());
            data.setDutyDate(one.getDutyDate());
            data.setCreateDate(new Date());
            data.setSelectivePerson(loginUser.getUserName());
            data.setStatus("0");
            boolean result = this.save(data);
            if (result) {
                TSysSelective newEntity = new TSysSelective();
                newEntity.setId(id);
                baseResponse.setData(newEntity);
            }
        }
        return baseResponse;
    }

    @Override
    public BaseResponse<TSysSelective> getByIds(String id) {
        BaseResponse<TSysSelective> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            TSysSelective data = this.getById(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }

    @Override
    public BaseResponse<BizGeneralResponse> updateEntity(TSysSelective updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            TSysSelective data = BeanHelper.beanToBean(updateRequest, TSysSelective.class);
            data.setIsIssue("0");
            if (!"".equals(data.getExistIssue()) || !"".equals(data.getIssuePhoto())) {
                data.setIsIssue("1");
            }
            boolean result = this.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @Override
    public BaseResponse<BizGeneralResponse> deleteEntity(TSysSelectiveDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            TSysSelective data = new TSysSelective();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = this.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }
}
