package com.testor.module.fives.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 5s工具运用opl对象 t_fives_tool_opl
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:54
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_fives_tool_opl")
@ApiModel(value = "TFivesToolOpl对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TFivesToolOpl extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 附件上传
     */
    @ApiModelProperty(value = "附件上传")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 知识类型（字典配置）
     */
    @ApiModelProperty(value = "知识类型（字典配置）")

    @TableField("kap_type")
    private String kapType;
    /**
     * 主题名称
     */
    @ApiModelProperty(value = "主题名称")

    @TableField("theme_name")
    private String themeName;
    /**
     * 小组名称
     */
    @ApiModelProperty(value = "小组名称")

    @TableField("group_name")
    private String groupName;
    /**
     * 课程描述
     */
    @ApiModelProperty(value = "课程描述")

    @TableField("course_des")
    private String courseDes;
    /**
     * 示意图一
     */
    @ApiModelProperty(value = "示意图一")

    @TableField("image_1")
    private String image1;
    /**
     * 示意图二
     */
    @ApiModelProperty(value = "示意图二")

    @TableField("image_2")
    private String image2;
    /**
     * 示意图三
     */
    @ApiModelProperty(value = "示意图三")

    @TableField("image_3")
    private String image3;

    /**
     * 编号
     */
    @ApiModelProperty(value = "编号")
    @TableField("serial_number")
    private String serialNumber;

    public static final String ID = "id";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String KAP_TYPE = "kap_type";
    public static final String THEME_NAME = "theme_name";
    public static final String GROUP_NAME = "group_name";
    public static final String COURSE_DES = "course_des";
    public static final String IMAGE_1 = "image_1";
    public static final String IMAGE_2 = "image_2";
    public static final String IMAGE_3 = "image_3";
    public static final String SERIAL_NUMBER = "serial_number";


}
