package com.testor.module.fives.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.module.fives.dao.TFivesToolCaseDao;
import com.testor.module.fives.model.domain.TFivesToolCase;
import com.testor.module.fives.model.excel.TFivesToolCaseReport;
import com.testor.module.fives.service.TFivesToolCaseService;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 5s工具运用改善案例Service业务层处理
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:52
 */
@Service("tFivesToolCaseServiceImpl")
public class TFivesToolCaseServiceImpl extends SuperServiceImpl<TFivesToolCaseDao, TFivesToolCase> implements TFivesToolCaseService {
    @Autowired(required = false)
    private TFivesToolCaseDao tFivesToolCaseDao;
    @Autowired
    private SysOrgService sysOrgService;
    @Override
    public List<TFivesToolCaseReport> exportFivesToolCase(String dsName, String datasetName, Map<String, Object> parameters) {

        List<TFivesToolCaseReport> tFivesToolOplReports = tFivesToolCaseDao.caseReport();
        Map<String,String> map=new HashMap<>(16);
        for (TFivesToolCaseReport toolOplReport : tFivesToolOplReports) {
            // 总部
            String areaOrgId = toolOplReport.getAreaOrgId();
            // 粮库
            String grainOrgId = toolOplReport.getGrainOrgId();
            if(StrUtil.isNotEmpty(grainOrgId)){
                String grainOrgName = orgName(map, grainOrgId);
                toolOplReport.setGrainOrgId(grainOrgName);
            }

            String areaOrgName = orgName(map, areaOrgId);
            toolOplReport.setAreaOrgId(areaOrgName);
        }
        return tFivesToolOplReports;
    }

    public String orgName(Map<String,String> map,String orgId){
        String orgName = map.get(orgId);
        if(StrUtil.isEmpty(orgName)){
            QueryWrapper<SysOrg> sysOrgQueryWrapper = new QueryWrapper<>();
            sysOrgQueryWrapper.eq("org_id", orgId);
            SysOrg sysOrg = sysOrgService.getOne(sysOrgQueryWrapper);

            orgName = sysOrg.getOrgName();

            map.put(orgId,orgName);
        }

        return orgName;
    }
}
