package com.testor.module.lease.model.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 租赁库管理关系对象 t_lease_bank
 * 
 * @author testor-framework
 * @date 2022-07-20 10:09:54
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_lease_bank")
@ApiModel(value = "TLeaseBank对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TLeaseBank extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 机构名称
 */
  @ApiModelProperty(value = "机构名称")

  @TableField("org_name")
  private String orgName;
/**
 * 租赁库名称
 */
  @ApiModelProperty(value = "租赁库名称")

  @TableField("lease_name")
  private String leaseName;
/**
 * 租赁库编号
 */
  @ApiModelProperty(value = "租赁库编号")

  @TableField("lease_code")
  private String leaseCode;
/**
 * 租赁库状态 0 正常 1 接触
 */
  @ApiModelProperty(value = "租赁库状态 0 正常 1 解除租赁")

  @TableField("lease_status")
  private String leaseStatus;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 关联ID
 */
  @ApiModelProperty(value = "关联ID")

  @TableField("ref_id")
  private String refId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 父级ID
 */
  @ApiModelProperty(value = "父级ID")

  @TableField("parent_id")
  private String parentId;
/**
 * 组织机构id
 */
  @ApiModelProperty(value = "组织机构id")

  @TableField("org_id")
  private String orgId;

  @TableField(exist = false)
  private String regionalCompany;

  public static final String ID ="id";
  public static final String ORG_NAME ="org_name";
  public static final String LEASE_NAME ="lease_name";
  public static final String LEASE_CODE ="lease_code";
  public static final String LEASE_STATUS ="lease_status";
  public static final String PROCESS_STATUS ="process_status";
  public static final String REF_ID ="ref_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PARENT_ID ="parent_id";
  public static final String ORG_ID ="org_id";


}
