package com.testor.module.mq.domain;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;


/**
 * 机构信息实体类
 */
@Data
public class OrganizationEntity {
    @ExcelProperty("机构名称")
    private String orgName;

    @ExcelProperty("备注")
    private String remark;

    @ExcelProperty("组织人员数量")
    private Integer personnelCount;

    @ExcelProperty("值班日志数量")
    private Integer dutyLogCount;

    @ExcelProperty("危险源数量")
    private Integer riskSourceCount;

    @ExcelProperty("风险点数量")
    private Integer riskPointCount;

    @ExcelProperty("隐患数量")
    private Integer hiddenDangerCount;

    @ExcelProperty("监控设备数量")
    private Integer monitorDeviceCount;

    @ExcelProperty("组织机构id")
    private String orgId;

    @ExcelProperty("报警总数")
    private Integer alarmCount;

    @ExcelProperty("危险作业次数")
    private Integer numberOfHazardousOperations;

    @ExcelProperty("相关方数量")
    private Integer numberOfInterestedParties;

    @ExcelProperty("相关方人数")
    private Integer numberOfRelevantPartyPersonnel;

    @ExcelProperty("应急预案数量")
    private Integer numberOfEmergencyPlans;

    @ExcelProperty("员工培训数量")
    private Integer numberOfStaffTraining;

    @ExcelProperty("三同时数量")
    private Integer trisimultaneousQuantity;

    @ExcelProperty("节能环保上报数量")
    private Integer energyConservationQuantity;

    @ExcelProperty("亮点数量")
    private Integer numberOfBrightSpots;

    @ExcelProperty("事故数量")
    private Integer numberOfAccidents;

    @ExcelProperty("公告数量")
    private Integer quantityOfAnnouncement;

    @ExcelProperty("新闻数量")
    private Integer newsQuantity;

    @ExcelProperty("租赁库数量")
    private Integer numberOfRentalWarehouses;

    @ExcelProperty("设备台账录入数量")
    private Integer equipmentLedgerEntryQuantity;

    @ExcelProperty("空间台账录入数量")
    private Integer spaceLedgerEntryQuantity;

}

