package com.testor.module.regime.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.regime.model.domain.TRegimeData;
import com.testor.module.regime.model.dto.ReturnReleaseUnit;
import com.testor.module.regime.model.dto.TRegimeDataDelParam;
import com.testor.module.regime.model.dto.TRegimeDataListVo;
import com.testor.module.regime.model.dto.TRegimeDataParam;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperService;

import java.util.List;

/**
 * 制度资料管理Service接口
 *
 * @author testor-framework
 * @date 2022-07-01 14:14:14
 */
public interface TRegimeDataService extends SuperService<TRegimeData> {

    BaseResponse<TRegimeData> addEntity(TRegimeData addRequest) throws Exception;

    BaseResponse<TRegimeData> getByIds(String id) throws Exception;

    BaseResponse<BizGeneralResponse> updateEntity(TRegimeData updateRequest) throws Exception;

    BaseResponse<BizGeneralResponse> deleteEntity(TRegimeDataDelParam deleteRequest) throws Exception;

    BaseResponse<List<ReturnReleaseUnit>> getReleaseUnit(String level) throws Exception;


    BaseResponseList<TRegimeDataListVo> pageList(Page<TRegimeData> resultPage, TRegimeDataParam param);




}
