package com.testor.module.safeCheck.model.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 巡检对象对象 t_safe_hazard_check_object
 * 
 * @author testor-framework
 * @date 2022-08-04 11:07:48
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_hazard_check_object")
@ApiModel(value = "TSafeHazardCheckObject对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeHazardCheckObject extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * id
 */
  @ApiModelProperty(value = "id")
  @TableId(value = "id",type = IdType.ASSIGN_UUID)
  private String id;
/**
 * 巡检计划id
 */
  @ApiModelProperty(value = "巡检计划id")

  @TableField("plan_id")
  private String planId;
/**
 * 对象分类id
 */
  @ApiModelProperty(value = "对象分类id")

  @TableField("obj_type_id")
  private String objTypeId;
/**
 * 排查对象
 */
  @ApiModelProperty(value = "排查对象")

  @TableField("obj_id")
  private String objId;
/**
 * 排查标准
 */
  @ApiModelProperty(value = "排查标准")

  @TableField("standard_id")
  private String standardId;

  @ApiModelProperty(value = "排查对象层级id")
  @TableField("obj_parent_ids")
  private String objParentIds;

  @ApiModelProperty(value = "排查标准层级id")
  @TableField("standard_parent_ids")
  private String standardParentIds;

  @ApiModelProperty(value = "类型(1-设备；2-空间；3-自定义)")
  @TableField("type")
  private String type;

  @ApiModelProperty(value = "对象分类层级id")
  @TableField("obj_type_parent_ids")
  private String objTypeParentIds;

  @ApiModelProperty(value = "排查对象分组号(前端使用,后端不处理)")
  @TableField("group_index")
  private String groupIndex;

  public static final String ID ="id";
  public static final String PLAN_ID ="plan_id";
  public static final String OBJ_TYPE_ID ="obj_type_id";
  public static final String OBJ_ID ="obj_id";
  public static final String STANDARD_ID ="standard_id";
  public static final String TYPE ="type";

}
