package com.testor.module.safeCheck.model.dto;

import com.testor.module.safeCheck.model.domain.TSafeHazardCheckResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 巡检结果 删除参数对象
 *
 * @author testor-framework
 * @date 2022-08-04 11:07:54
 */

@Data
@ApiModel(value = "TSafeHazardCheckResult 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TSafeHazardCheckResultParam extends TSafeHazardCheckResult {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "结果状态数组")
	List<Integer> resultStatusList;

}
