package com.testor.module.train.project.controller;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.testor.biz.file.controller.SysFileController;
import com.testor.biz.file.model.dto.FileAjaxDTO;
import com.testor.biz.file.model.dto.FileDTO;
import com.testor.common.api.FileController;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import freemarker.template.Configuration;
import freemarker.template.Template;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

@Controller
@RequestMapping("/scan")
@Api(value = "TTrainProject", tags = "安全培训教育——教育培训计划—扫码签到")
public class TTrainProjectScan {
    @Value("${train.path}")
    private String path;
    @Autowired
    private Configuration configuration;
    @Autowired
    private SysFileController sysFileController;
    @Autowired
    private FileController fileController;


    @ApiOperation(value = "生成二维码", notes = "")
    @GetMapping("/getScan")
    public BaseResponse<FileDTO> scanProject(String id , String str) throws Exception{
        HashMap hints = new HashMap();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        hints.put(EncodeHintType.MARGIN, 2);
        //二维码内容
        String text = "错误";
        switch (str) {
            case "扫码考试" :
                //微信扫码考试
//                text = path+"/#/Training/examinationManage/components/scanLogin?id="+id;
                // app 扫码考试
                text = "examination:"+id;
            break;
            case "扫码签到" :
                 // 微信扫码考试
//                text = path+"/#/Training/examinationManage/components/scanLogin?projectId="+id;
                // app端扫码考试
                text = id;
            break;
        }
//        String text = "http://192.168.70.229:9529/#/login";
        //图片大小
        int width = 300;
        int height = 300;
        //生成文件路径
//        String filePath = "D:/123.png";
        String fileName = id+".png";
        // 将生成的图片上传服务器========
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        BufferedImage bufferedImage = MatrixToImageWriter.toBufferedImage(bitMatrix);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ImageIO.write(bufferedImage, "png", stream);
        String base64 = "data:image/png;base64,"+Base64.getEncoder().encodeToString(stream.toByteArray());
        FileAjaxDTO fileAjaxDTO = new FileAjaxDTO();
        fileAjaxDTO.setFile(base64);
        fileAjaxDTO.setFileName(fileName);
        fileAjaxDTO.setFileSize("0");
        BaseResponse<FileDTO> fileDTOBaseResponse = fileController.uploadBase64(fileAjaxDTO);
        // 输出到本地文件夹
//        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
//        Path path = FileSystems.getDefault().getPath(filePath);
//        MatrixToImageWriter.writeToPath(bitMatrix, "PNG", path);
        return fileDTOBaseResponse;
    }

    @GetMapping("/index/{id}")
    public void userIndex(@PathVariable String id) throws Exception {

        Template template = configuration.getTemplate("01-basic.ftl");
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        template.process(map, new FileWriter("d:/list.html"));
//        ModelAndView view = new ModelAndView();
////        view.addObject("id", id);
//        view.setViewName("01-basic");
//        return view;
    }
}
