package com.testor.module.train.project.model.stat;

import com.baomidou.mybatisplus.annotation.TableField;
import com.testor.biz.file.model.dto.FileDTO;
import com.testor.module.aptitude.model.domain.TPersonAptitude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.util.List;

/**
 * <p>
 * 用户专业评分表
 * </p>
 *
 * @author caoqiang
 * @since 2024-09-07
 */
@Getter
@Setter
@Accessors(chain = true)
public class ProfessionalIndicatorScoreDetail {
    private String id;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 总分
     */
    private String totalScore;
    /**
     * 总分描述 专业指数得分在6分以下为不达标，6-8分为达标，8分以上为优秀
     */
    private String totalScoreDes;

    /**
     * 学历
     */
    private String education;
    private String educationScore;

    /**
     * 专业指标
     */
    private String speciality;
    private String specialityScore;
    private String educationSpecialityFileIds;
    private List<FileDTO> educationSpecialityFileDTOS;


    /**
     * 工作经验
     */
    private String workExperience;

    private String workExperienceScore;

    private String workExperienceFileIds;

    private List<FileDTO> workExperienceFileDTOS;

    /**
     * 专业资格  人员资质表 t_person_aptitude 表id 逗号分隔
     */
    private String personAptitudeIds;

    /**
     * 专业资格  人员资质表
     */
    private List<TPersonAptitude>  personAptitude;
    private String personAptitudeScore;


    /**
     * 工作成果
     */
    private List<String> workProduct;
    private String workProductFileIds;
    private String workProductScore;
    private List<FileDTO> workProductFileDTOS;

    /**
     * 奖励情况
     */
    private List<String> honors;
    private String honorsScore;
    @ApiModelProperty(value = "奖励情况文件id 逗号分隔")
    private String honorsFileIds;
    private List<FileDTO> honorsFileDTOS;

}
