/* Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.testor.workflow.form.model;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author sj 流程表单项
 */
@Data
public class ZFormItemDTO implements Serializable {

    @ApiModelProperty(required = true,value = "表单项Id,对应页面标签id,可理解为字段")
    private String id;
    @ApiModelProperty(required = true, value = "表单名称")
    private String name;
    @ApiModelProperty(value = "表单项默认值")
    private String value;

    @ApiModelProperty(value = "类型", hidden = true)
    private String fieldType = "FormField";

    @ApiModelProperty(value = "类型", hidden = true)
    private String type = "text";

    @ApiModelProperty(value = "类型", hidden = true)
    private boolean required = false;

    @ApiModelProperty(value = "类型", hidden = true)
    private boolean readOnly = false;

    @ApiModelProperty(value = "类型", hidden = true)
    private String placeholder = null;

    @ApiModelProperty(value = "类型", hidden = true)
    private String layout = null;
}
