/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.web.util.http.parser;

import com.tongweb.web.util.buf.MessageBytes;
import com.tongweb.web.util.http.HeaderUtil;
import com.tongweb.web.util.http.MimeHeaders;
import com.tongweb.web.util.http.parser.HttpParser;
import com.tongweb.web.util.res.StringManager;
import java.io.IOException;
import java.nio.ByteBuffer;

public class HttpHeaderParser {
    private static final StringManager sm = StringManager.getManager(HttpHeaderParser.class);
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte SP = 32;
    private static final byte HT = 9;
    private static final byte COLON = 58;
    private static final byte A = 65;
    private static final byte a = 97;
    private static final byte Z = 90;
    private static final byte LC_OFFSET = -32;
    private final HeaderDataSource source;
    private final MimeHeaders headers;
    private final boolean tolerantEol;
    private final HeaderParseData headerData = new HeaderParseData();
    private HeaderParsePosition headerParsePos = HeaderParsePosition.HEADER_START;
    private byte prevChr = 0;
    private byte chr = 0;

    public HttpHeaderParser(HeaderDataSource source, MimeHeaders headers, boolean tolerantEol) {
        this.source = source;
        this.headers = headers;
        this.tolerantEol = tolerantEol;
    }

    public void recycle() {
        this.chr = 0;
        this.prevChr = 0;
        this.headerParsePos = HeaderParsePosition.HEADER_START;
        this.headerData.recycle();
    }

    public HeaderParseStatus parseHeader() throws IOException {
        while (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            if (this.source.getHeaderByteBuffer().position() >= this.source.getHeaderByteBuffer().limit() && !this.source.fillHeaderBuffer()) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            this.prevChr = this.chr;
            this.chr = this.source.getHeaderByteBuffer().get();
            if (this.chr == 13 && this.prevChr != 13) continue;
            if (this.chr == 10) {
                if (!this.tolerantEol && this.prevChr != 13) {
                    throw new IllegalArgumentException(sm.getString("httpHeaderParser.invalidCrlfNoCR"));
                }
                return HeaderParseStatus.DONE;
            }
            if (this.prevChr == 13) {
                this.source.getHeaderByteBuffer().position(this.source.getHeaderByteBuffer().position() - 2);
                break;
            }
            this.source.getHeaderByteBuffer().position(this.source.getHeaderByteBuffer().position() - 1);
            break;
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_START) {
            this.headerData.lineStart = this.headerData.start = this.source.getHeaderByteBuffer().position();
            this.headerParsePos = HeaderParsePosition.HEADER_NAME;
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_NAME) {
            if (this.source.getHeaderByteBuffer().position() >= this.source.getHeaderByteBuffer().limit() && !this.source.fillHeaderBuffer()) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            int pos = this.source.getHeaderByteBuffer().position();
            this.chr = this.source.getHeaderByteBuffer().get();
            if (this.chr == 58) {
                if (this.headerData.start == pos) {
                    return this.skipLine();
                }
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE_START;
                this.headerData.headerValue = this.headers.addValue(this.source.getHeaderByteBuffer().array(), this.headerData.start, pos - this.headerData.start);
                this.headerData.start = pos = this.source.getHeaderByteBuffer().position();
                this.headerData.realPos = pos;
                this.headerData.lastSignificantChar = pos;
                break;
            }
            if (!HttpParser.isToken(this.chr)) {
                this.headerData.lastSignificantChar = pos;
                this.source.getHeaderByteBuffer().position(this.source.getHeaderByteBuffer().position() - 1);
                return this.skipLine();
            }
            if (this.chr < 65 || this.chr > 90) continue;
            this.source.getHeaderByteBuffer().put(pos, (byte)(this.chr - -32));
        }
        if (this.headerParsePos == HeaderParsePosition.HEADER_SKIPLINE) {
            return this.skipLine();
        }
        while (this.headerParsePos == HeaderParsePosition.HEADER_VALUE_START || this.headerParsePos == HeaderParsePosition.HEADER_VALUE || this.headerParsePos == HeaderParsePosition.HEADER_MULTI_LINE) {
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE_START) {
                do {
                    if (this.source.getHeaderByteBuffer().position() >= this.source.getHeaderByteBuffer().limit() && !this.source.fillHeaderBuffer()) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    this.chr = this.source.getHeaderByteBuffer().get();
                } while (this.chr == 32 || this.chr == 9);
                this.headerParsePos = HeaderParsePosition.HEADER_VALUE;
                this.source.getHeaderByteBuffer().position(this.source.getHeaderByteBuffer().position() - 1);
                this.chr = 0;
            }
            if (this.headerParsePos == HeaderParsePosition.HEADER_VALUE) {
                boolean eol = false;
                while (!eol) {
                    if (this.source.getHeaderByteBuffer().position() >= this.source.getHeaderByteBuffer().limit() && !this.source.fillHeaderBuffer()) {
                        return HeaderParseStatus.NEED_MORE_DATA;
                    }
                    this.prevChr = this.chr;
                    this.chr = this.source.getHeaderByteBuffer().get();
                    if (this.chr == 13 && this.prevChr != 13) continue;
                    if (this.chr == 10) {
                        if (!this.tolerantEol && this.prevChr != 13) {
                            throw new IllegalArgumentException(sm.getString("httpHeaderParser.invalidCrlfNoCR"));
                        }
                        eol = true;
                        continue;
                    }
                    if (this.prevChr == 13) {
                        return this.skipLine();
                    }
                    if (HttpParser.isControl(this.chr) && this.chr != 9) {
                        return this.skipLine();
                    }
                    if (this.chr == 32 || this.chr == 9) {
                        this.source.getHeaderByteBuffer().put(this.headerData.realPos, this.chr);
                        ++this.headerData.realPos;
                        continue;
                    }
                    this.source.getHeaderByteBuffer().put(this.headerData.realPos, this.chr);
                    this.headerData.lastSignificantChar = ++this.headerData.realPos;
                }
                this.headerData.realPos = this.headerData.lastSignificantChar;
                this.headerParsePos = HeaderParsePosition.HEADER_MULTI_LINE;
            }
            if (this.source.getHeaderByteBuffer().position() >= this.source.getHeaderByteBuffer().limit() && !this.source.fillHeaderBuffer()) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            byte peek = this.source.getHeaderByteBuffer().get(this.source.getHeaderByteBuffer().position());
            if (this.headerParsePos != HeaderParsePosition.HEADER_MULTI_LINE) continue;
            if (peek != 32 && peek != 9) {
                this.headerParsePos = HeaderParsePosition.HEADER_START;
                break;
            }
            this.source.getHeaderByteBuffer().put(this.headerData.realPos, peek);
            ++this.headerData.realPos;
            this.headerParsePos = HeaderParsePosition.HEADER_VALUE_START;
        }
        this.headerData.headerValue.setBytes(this.source.getHeaderByteBuffer().array(), this.headerData.start, this.headerData.lastSignificantChar - this.headerData.start);
        this.headerData.recycle();
        return HeaderParseStatus.HAVE_MORE_HEADERS;
    }

    private HeaderParseStatus skipLine() throws IOException {
        this.headerParsePos = HeaderParsePosition.HEADER_SKIPLINE;
        boolean eol = false;
        while (!eol) {
            if (this.source.getHeaderByteBuffer().position() >= this.source.getHeaderByteBuffer().limit() && !this.source.fillHeaderBuffer()) {
                return HeaderParseStatus.NEED_MORE_DATA;
            }
            int pos = this.source.getHeaderByteBuffer().position();
            this.prevChr = this.chr;
            this.chr = this.source.getHeaderByteBuffer().get();
            if (this.chr == 13) continue;
            if (this.chr == 10) {
                if (!this.tolerantEol && this.prevChr != 13) {
                    throw new IllegalArgumentException(sm.getString("httpHeaderParser.invalidCrlfNoCR"));
                }
                eol = true;
                continue;
            }
            this.headerData.lastSignificantChar = pos;
        }
        throw new IllegalArgumentException(sm.getString("httpHeaderParser.invalidHeader", HeaderUtil.toPrintableString(this.source.getHeaderByteBuffer().array(), this.headerData.lineStart, this.headerData.lastSignificantChar - this.headerData.lineStart + 1)));
    }

    public static interface HeaderDataSource {
        public boolean fillHeaderBuffer() throws IOException;

        public ByteBuffer getHeaderByteBuffer();
    }

    private static class HeaderParseData {
        int lineStart = 0;
        int start = 0;
        int realPos = 0;
        int lastSignificantChar = 0;
        MessageBytes headerValue = null;

        private HeaderParseData() {
        }

        public void recycle() {
            this.lineStart = 0;
            this.start = 0;
            this.realPos = 0;
            this.lastSignificantChar = 0;
            this.headerValue = null;
        }
    }

    public static enum HeaderParsePosition {
        HEADER_START,
        HEADER_NAME,
        HEADER_VALUE_START,
        HEADER_VALUE,
        HEADER_MULTI_LINE,
        HEADER_SKIPLINE;

    }

    public static enum HeaderParseStatus {
        DONE,
        HAVE_MORE_HEADERS,
        NEED_MORE_DATA;

    }
}

