package com.testor.common.constant;

import com.testor.common.util.CodeEnum;

public enum BelongUnitEnum implements CodeEnum {

    RELATED_PARTIES("0", "相关方"),
    UNIT("1", "本单位"),
    ;

    BelongUnitEnum(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private String code;

    private String msg;

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getMsg() {
        return msg;
    }

    public  static String getName(String value){
        for (BelongUnitEnum bean : BelongUnitEnum.values()) {
            if (bean.getCode().equals(value)) {
                return bean.getMsg();
            }
        }
        return value;
    }
}
