package com.testor.ddd.safetyControl.infrastructure.repository.riskStatistics.dao;

import com.testor.ddd.safetyControl.interfaces.model.dto.riskStatistics.RiskStatisticsDTO;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskStatistics.RiskStatisticsNumVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 危险源Mapper接口
 *
 * @author testor-framework
 * @date 2022-07-11 10:00:17
 */
@Service
public interface RiskStatisticsDao
{
    /**
     * 危险源数据统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsSourceNum(@Param("query") RiskStatisticsDTO param);

    /**
     * 危险源数据统计(根据车间场所类型分组)
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsSourceNumBySpaceType(@Param("query") RiskStatisticsDTO param);


    /**
     * 危险源等级统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsSourceLevel(@Param("query") RiskStatisticsDTO param);

    /**
     * 危险源类型统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsSourceType(@Param("query") RiskStatisticsDTO param);

    /**
     * 危险源数据统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsPointNum(@Param("query") RiskStatisticsDTO param);

    /**
     * 风险点数据统计(根据车间场所类型分组)
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsPointNumBySpaceType(@Param("query") RiskStatisticsDTO param);


    /**
     * 危险源等级统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsPointLevel(@Param("query") RiskStatisticsDTO param);

    /**
     * 危险源类型统计
     * @param param
     * @return
     */
    List<RiskStatisticsNumVO> statisticsPointType(@Param("query") RiskStatisticsDTO param);

}
