package com.testor.ddd.safetyControl.interfaces.model.dto.riskPointSource;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 风险点-危险源关联关系 删除参数对象
 *
 * @author testor-framework
 * @date 2022-07-20 14:18:13
 */

@Data
@ApiModel(value = "TSafeRiskPointSource 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TSafeRiskPointSourceDTOParam extends TSafeRiskPointSourceDTO {

	@ApiModelProperty(value = "车间场所id")
	private String workshopId;

	@ApiModelProperty(value = "作业区域id")
	private String workareaId;

	@ApiModelProperty(value = "设备id")
	private String equipmentId;

	@ApiModelProperty(value = "关联类型(1-设备；2-空间)")
	private Integer relationType;

	@ApiModelProperty(value = "非指定风险点数据")
	private String notPointId;

	@ApiModelProperty(value = "指定风险源")
	private List<String> condSourceIdList;
}
