package com.testor.ddd.safetyControl.interfaces.model.dto.space;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 空间场所 删除参数对象
 *
 * @author testor-framework
 * @date 2022-06-27 16:56:21
 */

@Data
@ApiModel(value = "TSafeSpace 列表查询参数对象")
@EqualsAndHashCode(callSuper = true)
public class TSafeSpaceDTOParam extends TSafeSpaceDTO {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "每页数量")
	private String limit;

	@ApiModelProperty(value = "当前页数")
	private String page;

	@ApiModelProperty(value = "排序字段")
	private String orderBy;

	@ApiModelProperty(value = "排序方式")
	private String orderType;

	@ApiModelProperty(value = "企业选择")
	private List<String> condOrgIdList;

	@ApiModelProperty(value = "选择的车间场所类型")
	private List<String> condSpaceTypeIdList;

	@ApiModelProperty(value = "选择车间场所idlist")
	private List<String> condSpaceIdList;

	@ApiModelProperty(value = "作业区域列表接口使用-车间场所名称")
	private String spaceName;
}
