package com.testor.module.accident.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 事故受伤人员对象 t_accident_personnel
 *
 * @author zhangyangfan@testor.com.cn
 * @date 2022-05-11 11:35:33
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_accident_personnel")
@ApiModel(value = "AccidentPersonnel对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class AccidentPersonnel extends SuperModel {
  private static final long serialVersionUID = 1L;
  /**
   * 主键ID
   */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
  /**
   * 关联ID
   */
  @ApiModelProperty(value = "关联ID")
  @TableField("ref_id")
  private String refId;
  /**
   * 父级ID
   */
  @ApiModelProperty(value = "父级ID")
  @TableField("parent_id")
  private String parentId;
  /**
   * 租户id
   */
  @ApiModelProperty(value = "租户id")
  @TableField("tenant_id")
  private String tenantId;
  /**
   * 流程实例ID
   */
  @ApiModelProperty(value = "流程实例ID")
  @TableField("process_id")
  private String processId;
  /**
   * 流程状态
   */
  @ApiModelProperty(value = "流程状态")
  @TableField("process_status")
  private String processStatus;
  /**
   * 归属类型（本单位、相关方）
   */
  @ApiModelProperty(value = "归属类型（本单位、相关方）")
  @TableField("belong_type")
  private String belongType;

  /**
   * 归属单位
   */
  @ApiModelProperty(value = "归属单位")
  @TableField("belong_unit")
  private String belongUnit;

  @ApiModelProperty(value = "人员id")
  @TableField("user_id")
  private String userId;

  @ApiModelProperty(value = "姓名", example = "0")
  @TableField("user_name")
  private String userName;
  /**
   * 年龄
   */
  @ApiModelProperty(value = "年龄", example = "0")
  @TableField("age")
  private Long age;
  /**
   * 性别0男1女
   */
  @ApiModelProperty(value = "性别0男1女")
  @TableField("sex")
  private String sex;

  public static final String ID = "id";
  public static final String REF_ID = "ref_id";
  public static final String PARENT_ID = "parent_id";
  public static final String TENANT_ID = "tenant_id";
  public static final String PROCESS_ID = "process_id";
  public static final String PROCESS_STATUS = "process_status";
  public static final String BELONG_TYPE = "belong_type";
  public static final String NAME = "name";
  public static final String AGE = "age";
  public static final String GENDER = "gender";


}
