package com.testor.module.contractor.manage.model.domain;

import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 承包商管理-竣工验收-竣工验收目录清单对象 t_contractor_acceptance_checklist
 * 
 * @author testor-framework
 * @date 2024-12-01 15:01:42
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_acceptance_checklist")
@ApiModel(value = "TContractorAcceptanceChecklist对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorAcceptanceChecklist extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 验收id
 */
  @ApiModelProperty(value = "验收id")

  @TableField("accept_id")
  private String acceptId;
/**
 * 目录清单名称
 */
  @ApiModelProperty(value = "目录清单名称")

  @TableField("title")
  private String title;
/**
 * 附件，存文件id
 */
  @ApiModelProperty(value = "附件，存文件id")

  @TableField("attachment")
  private String attachment;
/**
 * 是否符合要求 0不符合 1符合 2不涉及
 */
  @ApiModelProperty(value = "是否符合要求 0不符合 1符合 2不涉及")

  @TableField("if_pass")
  private String ifPass;
/**
 * 编号
 */
  @ApiModelProperty(value = "编号" , example = "0")

  @TableField("sort_no")
  private Long sortNo;

  public static final String ID ="id";
  public static final String ACCEPT_ID ="accept_id";
  public static final String TITLE ="title";
  public static final String ATTACHMENT ="attachment";
  public static final String IF_PASS ="if_pass";
  public static final String SORT_NO ="sort_no";


}
