package com.testor.module.hazard.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import lombok.EqualsAndHashCode;

/**
 * 承包商准入管理访问日志对象 t_contractor_access_log
 *
 * @author testor-framework
 * @date 2025-01-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_access_log")
@ApiModel(value = "TContractorAccessLog对象", description = "承包商准入管理访问日志")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorAccessLog extends SuperModel {
    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    @TableId("id")
    private String id;

    /**
     * 准入管理对象ID
     */
    @ApiModelProperty(value = "准入管理对象ID")
    @TableField("contractor_allow_id")
    private String contractorAllowId;

    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名")
    @TableField("person_name")
    private String personName;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别")
    @TableField("gender")
    private String gender;

    /**
     * 身份证号
     */
    @ApiModelProperty(value = "身份证号")
    @TableField("id_card_no")
    private String idCardNo;

    /**
     * 年龄
     */
    @ApiModelProperty(value = "年龄")
    @TableField("age")
    private Integer age;

    /**
     * 岗位性质id（数据字典id）
     */
    @ApiModelProperty(value = "岗位性质id（数据字典id）")
    @TableField("job_nature_id")
    private String jobNatureId;

    /**
     * 岗位性质
     */
    @ApiModelProperty(value = "岗位性质")
    @TableField("job_nature")
    private String jobNature;

    /**
     * 岗位名称id（数据字典id）
     */
    @ApiModelProperty(value = "岗位名称id（数据字典id）")
    @TableField("job_title_id")
    private String jobTitleId;

    /**
     * 岗位名称
     */
    @ApiModelProperty(value = "岗位名称")
    @TableField("job_title")
    private String jobTitle;

    /**
     * 联系电话
     */
    @ApiModelProperty(value = "联系电话")
    @TableField("tel")
    private String tel;

    /**
     * 所属企业id
     */
    @ApiModelProperty(value = "所属企业id")
    @TableField("org_id")
    private String orgId;

    /**
     * 工器具名称
     */
    @ApiModelProperty(value = "工器具名称")
    @TableField("tools_name")
    private String toolsName;

    /**
     * 工器具类别id（数据字典id）
     */
    @ApiModelProperty(value = "工器具类别id（数据字典id）")
    @TableField("tools_type_id")
    private String toolsTypeId;

    /**
     * 工器具类别
     */
    @ApiModelProperty(value = "工器具类别")
    @TableField("tools_type")
    private String toolsType;

    /**
     * 工器具型号
     */
    @ApiModelProperty(value = "工器具型号")
    @TableField("tools_model")
    private String toolsModel;

    /**
     * 工器具数量
     */
    @ApiModelProperty(value = "工器具数量")
    @TableField("tools_num")
    private Integer toolsNum;

    /**
     * 工器具用途
     */
    @ApiModelProperty(value = "工器具用途")
    @TableField("tools_purpose")
    private String toolsPurpose;

    /**
     * 工器具是否合格 0 不合格 1 合格
     */
    @ApiModelProperty(value = "工器具是否合格 0 不合格 1 合格")
    @TableField("tools_is_pass")
    private String toolsIsPass;

    /**
     * 物料名称
     */
    @ApiModelProperty(value = "物料名称")
    @TableField("material_name")
    private String materialName;

    /**
     * 物料类别id（数据字典id）
     */
    @ApiModelProperty(value = "物料类别id（数据字典id）")
    @TableField("material_type_id")
    private String materialTypeId;

    /**
     * 物料类别
     */
    @ApiModelProperty(value = "物料类别")
    @TableField("material_type")
    private String materialType;

    /**
     * 危险性id（数据字典id）
     */
    @ApiModelProperty(value = "危险性id（数据字典id）")
    @TableField("risk_id")
    private String riskId;

    /**
     * 危险性
     */
    @ApiModelProperty(value = "危险性")
    @TableField("risk")
    private String risk;

    /**
     * 物料型号
     */
    @ApiModelProperty(value = "物料型号")
    @TableField("material_model")
    private String materialModel;

    /**
     * 物料数量
     */
    @ApiModelProperty(value = "物料数量")
    @TableField("material_num")
    private Integer materialNum;

    /**
     * 物料用途
     */
    @ApiModelProperty(value = "物料用途")
    @TableField("material_purpose")
    private String materialPurpose;

    /**
     * 防护用品名称
     */
    @ApiModelProperty(value = "防护用品名称")
    @TableField("equipment_name")
    private String equipmentName;

    /**
     * 防护用品类别id（数据字典id）
     */
    @ApiModelProperty(value = "防护用品类别id（数据字典id）")
    @TableField("type_id")
    private String typeId;

    /**
     * 防护用品类别
     */
    @ApiModelProperty(value = "防护用品类别")
    @TableField("equipment_type")
    private String equipmentType;

    /**
     * 常规用品 0否 1是
     */
    @ApiModelProperty(value = "常规用品 0否 1是")
    @TableField("is_general")
    private String isGeneral;

    /**
     * 防护用品型号
     */
    @ApiModelProperty(value = "防护用品型号")
    @TableField("equipment_model")
    private String equipmentModel;

    /**
     * 防护用品数量
     */
    @ApiModelProperty(value = "防护用品数量")
    @TableField("equipment_num")
    private Integer equipmentNum;

    /**
     * 防护用品用途
     */
    @ApiModelProperty(value = "防护用品用途")
    @TableField("equipment_purpose")
    private String equipmentPurpose;

    /**
     * 批次
     */
    @ApiModelProperty(value = "批次")
    @TableField("batch")
    private String batch;

    /**
     * 修改项(1:人员 2:工器具 3:防护用品数量 4:防护用品数量)
     */
    @ApiModelProperty(value = "修改项(1:人员 2:工器具 3:防护用品数量 4:物料数量)")
    @TableField("type")
    private String type;

    /**
     * 历史内容
     */
    @ApiModelProperty(value = "历史内容")
    @TableField("historical_content")
    private String historicalContent;

    @TableField(exist = false)
    private String createByName;

    // 常量定义
    public static final String ID = "id";
    public static final String CONTRACTOR_ALLOW_ID = "contractor_allow_id";
    public static final String PERSON_NAME = "person_name";
    public static final String GENDER = "gender";
    public static final String ID_CARD_NO = "id_card_no";
    public static final String AGE = "age";
    public static final String JOB_NATURE_ID = "job_nature_id";
    public static final String JOB_NATURE = "job_nature";
    public static final String JOB_TITLE_ID = "job_title_id";
    public static final String JOB_TITLE = "job_title";
    public static final String TEL = "tel";
    public static final String STATUS = "status";
    public static final String ORG_ID = "org_id";
    public static final String TOOLS_NAME = "tools_name";
    public static final String TOOLS_TYPE_ID = "tools_type_id";
    public static final String TOOLS_TYPE = "tools_type";
    public static final String TOOLS_MODEL = "tools_model";
    public static final String TOOLS_NUM = "tools_num";
    public static final String TOOLS_PURPOSE = "tools_purpose";
    public static final String TOOLS_IS_PASS = "tools_is_pass";
    public static final String MATERIAL_NAME = "material_name";
    public static final String MATERIAL_TYPE_ID = "material_type_id";
    public static final String MATERIAL_TYPE = "material_type";
    public static final String RISK_ID = "risk_id";
    public static final String RISK = "risk";
    public static final String MATERIAL_MODEL = "material_model";
    public static final String MATERIAL_NUM = "material_num";
    public static final String MATERIAL_PURPOSE = "material_purpose";
    public static final String EQUIPMENT_NAME = "equipment_name";
    public static final String TYPE_ID = "type_id";
    public static final String EQUIPMENT_TYPE = "equipment_type";
    public static final String IS_GENERAL = "is_general";
    public static final String EQUIPMENT_MODEL = "equipment_model";
    public static final String EQUIPMENT_NUM = "equipment_num";
    public static final String EQUIPMENT_PURPOSE = "equipment_purpose";
    public static final String BATCH = "batch";
    public static final String REMARKS = "remarks";
    public static final String TYPE = "type";
}