package com.testor.module.hazard.service;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.hazard.model.domain.THazardWorkPlan;
import com.testor.module.hazard.model.dto.*;
import com.testor.module.wf.vo.HisTasksResponseDTO;
import com.tongtech.tfw.backend.common.models.supers.SuperService;
import com.tongtech.tfw.workflow.apis.task.model.dto.*;
import org.apache.ibatis.annotations.Param;

import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;
import java.util.Map;

/**
 * 危险作业计划Service接口
 * 
 * @author testor-framework
 * @date 2024-12-19 10:39:26
 */
public interface THazardWorkPlanService extends SuperService<THazardWorkPlan> {

    /**
     * 获取详情
     * @param id
     * @return
     */
    THazardWorkPlanDTO getDetailsById(String id);


    Page<THazardWorkPlanDTO> listEntity(THazardWorkPlanParam param);

    List<THazardWorkPlanDTO> listAllEntity(THazardWorkPlanParam param);

    void submit(THazardWorkPlanDTO tHazardWorkPlanDTO);

    /**
     * 新增危险作业
     * @param addRequest
     * @return
     */
    THazardWorkPlan addEntity(THazardWorkPlan addRequest);

    void completeProcess(THazardWorkPlanDTO tHazardWorkPlanDTO);

    /**
     * 根据 机构id获取机构名称
     * @param orgId 机构id 格式 0-id,1-id(0是系统内部企业，1是承包商机构)
     * @return
     */
    String getOrgNamesByOrgId(String orgId);

    /**
     * 根据用户id集合获取用户名集合
     * @param allUserIds 用户id集合 格式 0-id,1-id(0是系统内部用户，1是承包商用户)
     * @return
     */
    String getUserNamesByUserIds(String allUserIds);

    /**
     * 根据用户id集合获取机构名称集合
     * @param allUserIds 用户id集合 格式 0-id,1-id(0是系统内部用户，1是承包商用户)
     * @return
     */
    String getOrgNamesByUserIds(String allUserIds);

    List<HisTasksResponseDTO> getHistoryByInstanceId(HisTasksRequest hisTasksRequest, String planId);

    IPage<TodoTaskDTO> selectToDoList(TodoListRequest todoListRequest);

    void rejectedProcess(THazardWorkPlanDTO tHazardWorkPlanDTO);

    /**
     * 取消流程
     * @param completeTask
     */
    void cancelProcess(@Valid CompleteTask completeTask);

    void cancelChildTasks(CompleteTask completeTask);

    void hazardousWorkMessageAlerts();

    THazardWorkPlan updateEntity(THazardWorkPlan updateRequest);

    IPage<HisTaskDTO> hisTaskList(HisTaskListRequest hisTaskListRequest);

    boolean exportJobTicket(HttpServletResponse response, THazardWorkPlanParam param);

    List<TaskInfoDTO> getAllTaskApprovers(String processInstanceId, String planId);

    public String getOrgNamesByOrgIds(String orgId);

    /**
     * 危险作业计划时间是否合规
     * @param workType 危险作业类型
     * @param workLevel 危险等级
     * @param scheduledStartTime 计划开始时间
     * @param scheduledEndTime 计划结束时间
     * @return
     */
    //String validateOperation(String workType, String workLevel, String scheduledStartTime,String scheduledEndTime);

    /**
     * 任务转签
     * @param transferDTO
     */
    public void transferTask(TransferDTO transferDTO);

    /**
     * 任务撤回
     * @param processInstanceId 流程实例id
     * @param operator 操作人
     * @param targetActivityId 目标节点id
     */
    public void recallProcess(CompleteTask completeTask);

    /**
     * 对外沿江大区提供危险作业数据
     * @return
     */
    Page<THazardWorkPlanRiverside> riversideList(THazardWorkPlanParam param);

    /**
     * 查询已完成的危险作业数量
     * @return
     */
    Integer completedCount(List<String> orgIds);

    /**
     * 查询未完成的危险作业数量
     * @return
     */
    Integer unfinishedCount(List<String> orgIds);

}
