package com.testor.module.safe.model.vo;

import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;


/**
 * 隐患巡检排查标准对象 t_safe_hazard_standard
 *
 * @author testor-framework
 * @date 2022-07-27 14:48:45
 */
@Data
@ApiModel(value = "TSafeHazardStandardEditDTO 对象", description = "")
public class TSafeHazardStandardVO extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;


    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")
    private String processStatus;
    /**
     * 级别分类（总部/区域公司/基层粮库）
     */
    @ApiModelProperty(value = "级别分类（总部/区域公司/基层粮库）")
    private String levelType;
    /**
     * 标准分类
     */
    @ApiModelProperty(value = "标准分类")
    private String standardType;
    /**
     * 标准名称
     */
    @ApiModelProperty(value = "标准名称")
    private String standardName;
    /**
     * 单位名称（当前登录用户所属机构id）
     */
    @ApiModelProperty(value = "单位名称（当前登录用户所属机构id）")
    private String orgId;
    /**
     * 标准状态（禁用/现行/废止  执行流程改变状态）
     */
    @ApiModelProperty(value = "标准状态（禁用/现行/废止  执行流程改变状态）")
    private String standardStatus;


    @ApiModelProperty(value = "企业名称")
    private String orgName;

    @ApiModelProperty(value = "检查项细则")
    private List<TSafeHazardOptionVO> tsafeHazardOptionEditDTOList;

}
