package com.testor.module.safeCheck.model.domain;

import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 安全检查计划人员安排(具体人员)对象 t_safe_check_person_arrange
 * 
 * @author testor-framework
 * @date 2024-09-05 02:25:41
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_safe_check_person_arrange")
@ApiModel(value = "TSafeCheckPersonArrange对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSafeCheckPersonArrange extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;
/**
 * t_safe_chek_person表关联id
 */
  @ApiModelProperty(value = "t_safe_chek_person表关联id")

  @TableField("check_person_id")
  private String checkPersonId;
/**
 * 检查人员id
 */
  @ApiModelProperty(value = "检查人员id")

  @TableField("user_id")
  private String userId;

  /**
   * 检查人员id
   */
  @ApiModelProperty(value = "检查人员名称")

  @TableField(exist = false)
  private String userName;

/**
 * 计划id
 */
  @ApiModelProperty(value = "计划id")

  @TableField("plan_id")
  private String planId;

  /**
   * 流程id
   */
  @ApiModelProperty(value = "流程id")

  @TableField("process_id")
  private String processId;
  /**
   * 流程状态 3待审批
   */
  @ApiModelProperty(value = "流程状态 3待审批")

  @TableField("process_status")
  private String processStatus;

  public static final String ID ="id";
  public static final String CHECK_PERSON_ID ="check_person_id";
  public static final String USER_ID ="user_id";
  public static final String PLAN_ID ="plan_id";


}
