package com.testor.module.train.paper.model.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 试卷管理——安全教育培训对象 t_train_paper
 *
 * @author testor-framework
 * @date 2022-07-13 15:25:11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_paper")
@ApiModel(value = "TTrainPaper对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainPaper extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 满分分数
     */
    @ApiModelProperty(value = "满分分数", example = "0")

    @TableField("full_score")
    private Long fullScore;
    /**
     * 及格分数
     */
    @ApiModelProperty(value = "及格分数", example = "0")

    @TableField("pass_score")
    private Long passScore;
    /**
     * 关联ID
     */
    @ApiModelProperty(value = "关联ID")

    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")

    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 单选分数
     */
    @ApiModelProperty(value = "单选分数", example = "0")

    @TableField("single_score")
    private Long singleScore;
    /**
     * 多选分数
     */
    @ApiModelProperty(value = "多选分数", example = "0")

    @TableField("more_score")
    private Long moreScore;
    /**
     * 判端分数
     */
    @ApiModelProperty(value = "判端分数", example = "0")

    @TableField("judge_score")
    private Long judgeScore;
    /**
     * 试卷状态
     */
    @ApiModelProperty(value = "试卷状态 （1 开启 0 关闭）")

    @TableField("test_paper_status")
    private String testPaperStatus;
    /**
     * 试卷名称
     */
    @ApiModelProperty(value = "试卷名称")

    @TableField("test_paper_name")
    private String testPaperName;
    /**
     * 题库名称
     */
    @ApiModelProperty(value = "题库名称")

    @TableField("question_bank_name")
    private String questionBankName;
    /**
     * 试卷简介
     */
    @ApiModelProperty(value = "试卷简介")

    @TableField("test_paper_intro")
    private String testPaperIntro;
    /**
     * 组卷方式
     */
    @ApiModelProperty(value = "组卷方式 1 随机  2 手动")

    @TableField("group_paper_way")
    private String groupPaperWay;

    /**
     * 试题id
     */
    @ApiModelProperty(value = "试题id")

    @TableField("test_questions_id")
    private String testQuestionsId;

    @ApiModelProperty(value = "单选题数量")
    @TableField("select_num")
    private Long selectNum;

    @ApiModelProperty(value = "多选题数量")
    @TableField("more_select_num")
    private Long moreSelectNum;

    @ApiModelProperty(value = "判断题数量")
    @TableField("judge_num")
    private Long judgeNum;

    @ApiModelProperty(value = "已选试题数")
    @TableField("amount")
    private Long amount;

    @ApiModelProperty(value = "组织机构id")
    @TableField("org_id")
    private String orgId;

    @ApiModelProperty(value = "机构名称")
    @TableField("org_name")
    private String orgName ;

    public static final String ID = "id";
    public static final String FULL_SCORE = "full_score";
    public static final String PASS_SCORE = "pass_score";
    public static final String REF_ID = "ref_id";
    public static final String PARENT_ID = "parent_id";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String PROCESS_ID = "process_id";
    public static final String SINGLE_SCORE = "single_score";
    public static final String MORE_SCORE = "more_score";
    public static final String JUDGE_SCORE = "judge_score";
    public static final String TEST_PAPER_STATUS = "test_paper_status";
    public static final String TEST_PAPER_NAME = "test_paper_name";
    public static final String QUESTION_BANK_NAME = "question_bank_name";
    public static final String TEST_PAPER_INTRO = "test_paper_intro";
    public static final String GROUP_PAPER_WAY = "group_paper_way";
    public static final String ORG_ID = "org_id";
    public static final String ORG_NAME = "orgName";


}
