/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.exception;

import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import java.util.List;
import java.util.Optional;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingPathVariableException;
import org.springframework.web.bind.MissingServletRequestParameterException;

public class MvcExceptionFormatter {
    public static String formatException(Exception exception) {
        if (null == exception) {
            return null;
        }
        if (exception instanceof MethodArgumentNotValidException) {
            StringBuilder builder = new StringBuilder("\u6821\u9a8c\u5931\u8d25:");
            List allErrors = ((MethodArgumentNotValidException)exception).getBindingResult().getAllErrors();
            allErrors.stream().findFirst().ifPresent(error -> builder.append(((FieldError)error).getField()).append(" \u5b57\u6bb5\u89c4\u5219\u4e3a ").append(error.getDefaultMessage()));
            return builder.toString();
        }
        if (exception instanceof MissingServletRequestParameterException) {
            MissingServletRequestParameterException ex = (MissingServletRequestParameterException)exception;
            String builder = "\u53c2\u6570\u5b57\u6bb5" + ex.getParameterName() + "\u6821\u9a8c\u4e0d\u901a\u8fc7";
            return builder;
        }
        if (exception instanceof MissingPathVariableException) {
            MissingPathVariableException ex = (MissingPathVariableException)exception;
            String builder = "\u8def\u5f84\u5b57\u6bb5" + ex.getVariableName() + "\u6821\u9a8c\u4e0d\u901a\u8fc7";
            return builder;
        }
        if (exception instanceof ConstraintViolationException) {
            StringBuilder builder = new StringBuilder("\u65b9\u6cd5.\u53c2\u6570\u5b57\u6bb5");
            ConstraintViolationException ex = (ConstraintViolationException)exception;
            Optional first = ex.getConstraintViolations().stream().findFirst();
            if (first.isPresent()) {
                ConstraintViolation constraintViolation = (ConstraintViolation)first.get();
                builder.append(constraintViolation.getPropertyPath().toString());
                builder.append("\u6821\u9a8c\u4e0d\u901a\u8fc7");
            }
            return builder.toString();
        }
        if (exception instanceof HttpMessageNotReadableException && exception.getCause() instanceof MismatchedInputException) {
            StringBuilder builder = new StringBuilder("\u53c2\u6570\u5b57\u6bb5");
            MismatchedInputException ex = (MismatchedInputException)exception.getCause();
            List referenceList = ex.getPath();
            referenceList.stream().findFirst().ifPresent(reference -> builder.append(reference.getFieldName()));
            builder.append(" \u671f\u671b\u7c7b\u578b: ").append(ex.getTargetType());
            return builder.toString();
        }
        return exception.toString();
    }
}

