/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.workflow.apis.user.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.workflow.apis.user.model.domain.ActIdGroup;
import com.tongtech.tfw.workflow.apis.user.model.domain.ActIdUser;
import com.tongtech.tfw.workflow.apis.user.model.dto.IdmUser;
import com.tongtech.tfw.workflow.apis.user.service.ActIdGroupService;
import com.tongtech.tfw.workflow.apis.user.service.ActIdUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.User;
import org.flowable.ui.common.model.GroupRepresentation;
import org.flowable.ui.common.model.RemoteGroup;
import org.flowable.ui.common.model.ResultListDataRepresentation;
import org.flowable.ui.common.model.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="Idm app", tags={"WF-IDM-\u8986\u76d6"})
@RequestMapping(value={"/app"})
public class IdmAppController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(IdmAppController.class);
    @Autowired
    private ActIdUserService actIdUserService;
    @Autowired
    private ActIdGroupService actIdGroupService;

    @ApiOperation(value="\u83b7\u53d6\u53ef\u9009\u7528\u6237", notes="List editor user all")
    @GetMapping(value={"/rest/editor-users"})
    public ResultListDataRepresentation getUsers(@RequestParam(value="filter", required=false) String filter) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotBlank((CharSequence)filter)) {
            queryWrapper.like((Object)"FIRST_", (Object)filter);
        }
        List matchingUsers = this.actIdUserService.list((Wrapper)queryWrapper);
        ArrayList<UserRepresentation> userRepresentations = new ArrayList<UserRepresentation>(matchingUsers.size());
        for (ActIdUser actIdUser : matchingUsers) {
            User user = (User)BeanHelper.beanToBean((Object)actIdUser, IdmUser.class);
            user.setFirstName(actIdUser.getFirst());
            user.setDisplayName(actIdUser.getFirst());
            userRepresentations.add(new UserRepresentation(user));
        }
        return new ResultListDataRepresentation(userRepresentations);
    }

    @ApiOperation(value="\u83b7\u53d6\u53ef\u9009\u7528\u6237\u7ec4", notes="List editor group all")
    @GetMapping(value={"/rest/editor-groups"})
    public ResultListDataRepresentation getGroups(@RequestParam(required=false, value="filter") String filter) {
        ArrayList<GroupRepresentation> result = new ArrayList<GroupRepresentation>();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotBlank((CharSequence)filter)) {
            queryWrapper.like((Object)"NAME_", (Object)filter);
        }
        List groups = this.actIdGroupService.list((Wrapper)queryWrapper);
        for (ActIdGroup actIdGroup : groups) {
            RemoteGroup group = (RemoteGroup)BeanHelper.beanToBean((Object)actIdGroup, RemoteGroup.class);
            result.add(new GroupRepresentation((Group)group));
        }
        return new ResultListDataRepresentation(result);
    }
}

