/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.excel.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.testor.biz.excel.ExcelConstants;
import com.testor.biz.file.FileEnumCode;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.datetime.DatetimeHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExcelService {
    private static final Logger log = LoggerFactory.getLogger(ExcelService.class);
    @Value(value="${file.path}")
    private String fileRootPath;
    private static final String PATH_SLASH = File.separator;

    public <T> void export(String fileName, List<T> data, Class<?> dataType, HttpServletResponse response, List<String> cols) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        fileName = URLEncoder.encode(fileName, "UTF-8");
        fileName = StringHelper.replace((String)fileName, (String)"+", (String)"%20");
        response.setHeader("Access-Control-Expose-Headers", "Content-disposition");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        if (ObjectHelper.isNotEmpty(cols)) {
            HashSet<String> includeColumnFiledNames = new HashSet<String>(cols);
            ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), dataType).includeColumnFiledNames(includeColumnFiledNames)).sheet("\u6570\u636e").doWrite(data);
        } else {
            EasyExcel.write((OutputStream)response.getOutputStream(), dataType).sheet("\u6570\u636e").doWrite(data);
        }
    }

    public String importExcel(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        int beginIndex = fileName.indexOf(".") + 1;
        String ext = StringHelper.substring((String)fileName, (int)beginIndex, (int)fileName.length());
        String filePath = DatetimeHelper.getDateTime8Length();
        String saveName = IdHelper.getId32bit();
        try {
            File path = new File(new File("excel").getAbsolutePath() + ExcelConstants.PATH_SLASH + "import" + ExcelConstants.PATH_SLASH + filePath);
            if (!path.exists()) {
                path.mkdirs();
            }
            File dest = new File(path.getAbsolutePath() + ExcelConstants.PATH_SLASH + saveName + "." + ext);
            FileCopyUtils.copy((byte[])file.getBytes(), (File)dest);
            log.info("\u4fdd\u5b58\u6210\u529f\uff1aFileId\uff1a" + saveName + ", ext: " + ext + ", path:" + filePath + ", name:" + fileName);
            return dest.getAbsolutePath();
        }
        catch (IOException e) {
            log.error(e.toString(), (Throwable)e);
            throw new ApiException(FileEnumCode.IO_FAILD.transform());
        }
    }

    public <T> String errorHistory(List<T> errorList, Class<?> dataType) throws FileNotFoundException {
        String fileName = IdHelper.getId32bit();
        File path = new File(new File("excel").getAbsolutePath() + ExcelConstants.PATH_SLASH + "history");
        if (!path.exists()) {
            path.mkdirs();
        }
        File dest = new File(new File("excel").getAbsolutePath() + ExcelConstants.PATH_SLASH + "history" + ExcelConstants.PATH_SLASH + fileName + "." + "xlsx");
        EasyExcel.write((OutputStream)new FileOutputStream(dest), dataType).sheet("\u6570\u636e").doWrite(errorList);
        return fileName;
    }
}

