/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.sanyuan.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.sanyuan.model.domain.SysSanyuan;
import com.testor.biz.sys.sanyuan.model.dto.SysSanyuanDelParam;
import com.testor.biz.sys.sanyuan.model.dto.SysSanyuanParam;
import com.testor.biz.sys.sanyuan.service.SysSanyuanService;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.biz.sys.user.service.SysUserService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sanyuan/audit"})
@Api(value="SysSanyuan", tags={"SysSanyuan \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c"})
public class SysSanyuanController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(SysSanyuanController.class);
    @Autowired
    private SysSanyuanService sysSanyuanService;
    @Autowired
    private SysUserService sysUserService;

    @ApiOperation(value="\u65b0\u589e \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c", notes="\u65b0\u589e \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c Add SysSanyuan")
    @PostMapping(value={"/add"})
    public BaseResponse<SysSanyuan> addEntity(@RequestBody SysSanyuan addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)addRequest))) {
            String id = IdHelper.getId32bit();
            SysSanyuan data = (SysSanyuan)((Object)BeanHelper.beanToBean((Object)((Object)addRequest), SysSanyuan.class));
            data.setId(id);
            boolean result = this.sysSanyuanService.save((Object)data);
            if (result) {
                SysSanyuan newEntity = new SysSanyuan();
                newEntity.setId(id);
                baseResponse.setData((Object)newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c ", notes="\u83b7\u53d6 \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c Get SysSanyuan By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<SysSanyuan> getById(String syId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)syId)) {
            SysSanyuan data = (SysSanyuan)((Object)this.sysSanyuanService.getById((Serializable)((Object)syId)));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539 \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c ", notes="\u4fee\u6539 \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c Update SysSanyuan By Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody SysSanyuan updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)updateRequest)) && StringHelper.isNotEmpty((CharSequence)updateRequest.getId())) {
            SysSanyuan data = (SysSanyuan)((Object)BeanHelper.beanToBean((Object)((Object)updateRequest), SysSanyuan.class));
            boolean result = this.sysSanyuanService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5ba1\u6279 \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c ", notes="\u5ba1\u6279 \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c Audit SysSanyuan By Id")
    @PutMapping(value={"/audit"})
    public BaseResponse<BizGeneralResponse> auditEntity(@RequestBody SysSanyuan updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)updateRequest)) && StringHelper.isNotEmpty((CharSequence)updateRequest.getId())) {
            SysUser sysUser = (SysUser)((Object)this.sysUserService.getById((Serializable)((Object)this.getUserId())));
            SysSanyuan data = (SysSanyuan)((Object)BeanHelper.beanToBean((Object)((Object)updateRequest), SysSanyuan.class));
            data.setSyOpAuditDate(LocalDateTime.now());
            data.setSyOpAuditor(null != sysUser ? sysUser.getUserName() : "test");
            boolean result = this.sysSanyuanService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664 \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c ", notes="\u5220\u9664 \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c delete SysSanyuan By Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody SysSanyuanDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && StringHelper.isNotEmpty((CharSequence)deleteRequest.getId())) {
            SysSanyuan data = new SysSanyuan();
            data.setId(deleteRequest.getId());
            data.setStatus("1");
            boolean result = this.sysSanyuanService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u4e09\u5458\u5ba1\u6279\u64cd\u4f5c", notes="\u6279\u91cf\u5220\u9664\u4e09\u5458\u5ba1\u6279\u64cd\u4f5c delete SysSanyuan by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody SysSanyuanDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            ArrayList<SysSanyuan> sysSanyuanList = new ArrayList<SysSanyuan>();
            for (String id : deleteRequest.getIds()) {
                SysSanyuan data = new SysSanyuan();
                data.setId(id);
                data.setStatus("1");
                sysSanyuanList.add(data);
            }
            boolean result = this.sysSanyuanService.updateBatchById(sysSanyuanList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c \u5206\u9875\u5217\u8868", notes="\u83b7\u53d6 \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c \u5206\u9875\u5217\u8868 List SysSanyuan with page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<SysSanyuan>> listEntity(SysSanyuanParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<SysSanyuan> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.sysSanyuanService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c \u5217\u8868", notes="\u83b7\u53d6 \u4e09\u5458\u5ba1\u6279\u64cd\u4f5c \u5217\u8868 List SysSanyuan all")
    @GetMapping(value={"/datas"})
    public BaseResponse<BaseResponseList<SysSanyuan>> listAllEntity(SysSanyuanParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<SysSanyuan> queryWrapper = this.createQuery(param);
        List resultList = this.sysSanyuanService.list((Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<SysSanyuan> createQuery(SysSanyuanParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getSyOp())) {
            queryWrapper.like((Object)"sy_op", (Object)queryParam.getSyOp());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getSyOpType())) {
            queryWrapper.eq((Object)"sy_op_type", (Object)queryParam.getSyOpType());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getSyOpUrl())) {
            queryWrapper.eq((Object)"sy_op_url", (Object)queryParam.getSyOpUrl());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getSyOpMethod())) {
            queryWrapper.eq((Object)"sy_op_method", (Object)queryParam.getSyOpMethod());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getSyOpData())) {
            queryWrapper.eq((Object)"sy_op_data", (Object)queryParam.getSyOpData());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getSyOpMsg())) {
            queryWrapper.eq((Object)"sy_op_msg", (Object)queryParam.getSyOpMsg());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getSyOpApplier())) {
            queryWrapper.eq((Object)"sy_op_applier", (Object)queryParam.getSyOpApplier());
        }
        if (ObjectHelper.isNotEmpty((Object)queryParam.getSyOpApplyDate())) {
            queryWrapper.eq((Object)"sy_op_apply_date", (Object)queryParam.getSyOpApplyDate());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getSyOpApplyOrg())) {
            queryWrapper.eq((Object)"sy_op_apply_org", (Object)queryParam.getSyOpApplyOrg());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getSyOpAuditor())) {
            queryWrapper.eq((Object)"sy_op_auditor", (Object)queryParam.getSyOpAuditor());
        }
        if (ObjectHelper.isNotEmpty((Object)queryParam.getSyOpAuditDate())) {
            queryWrapper.eq((Object)"sy_op_audit_date", (Object)queryParam.getSyOpAuditDate());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getSyOpAuditOrg())) {
            queryWrapper.eq((Object)"sy_op_audit_org", (Object)queryParam.getSyOpAuditOrg());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getSyOpAuditState())) {
            queryWrapper.eq((Object)"sy_op_audit_state", (Object)queryParam.getSyOpAuditState());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getSyOpBizState())) {
            queryWrapper.eq((Object)"sy_op_biz_state", (Object)queryParam.getSyOpBizState());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getCreateBy())) {
            queryWrapper.eq((Object)"create_by", (Object)queryParam.getCreateBy());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByAsc((Object[])new String[]{"sy_op_audit_state", "create_date"});
        }
        return queryWrapper;
    }
}

