/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.miniws;

import com.tongtech.miniws.WebSocket;
import com.tongtech.miniws.drafts.Draft;
import com.tongtech.miniws.exceptions.InvalidDataException;
import com.tongtech.miniws.framing.Framedata;
import com.tongtech.miniws.framing.PingFrame;
import com.tongtech.miniws.handshake.ClientHandshake;
import com.tongtech.miniws.handshake.Handshakedata;
import com.tongtech.miniws.handshake.ServerHandshake;
import com.tongtech.miniws.handshake.ServerHandshakeBuilder;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public interface WebSocketListener {
    public ServerHandshakeBuilder onWebsocketHandshakeReceivedAsServer(WebSocket var1, Draft var2, ClientHandshake var3) throws InvalidDataException;

    public void onWebsocketHandshakeReceivedAsClient(WebSocket var1, ClientHandshake var2, ServerHandshake var3) throws InvalidDataException;

    public void onWebsocketHandshakeSentAsClient(WebSocket var1, ClientHandshake var2) throws InvalidDataException;

    public void onWebsocketMessage(WebSocket var1, String var2);

    public void onWebsocketMessage(WebSocket var1, ByteBuffer var2);

    public void onWebsocketOpen(WebSocket var1, Handshakedata var2);

    public void onWebsocketClose(WebSocket var1, int var2, String var3, boolean var4);

    public void onWebsocketClosing(WebSocket var1, int var2, String var3, boolean var4);

    public void onWebsocketCloseInitiated(WebSocket var1, int var2, String var3);

    public void onWebsocketError(WebSocket var1, Exception var2);

    public void onWebsocketPing(WebSocket var1, Framedata var2);

    public PingFrame onPreparePing(WebSocket var1);

    public void onWebsocketPong(WebSocket var1, Framedata var2);

    public void onWriteDemand(WebSocket var1);

    public InetSocketAddress getLocalSocketAddress(WebSocket var1);

    public InetSocketAddress getRemoteSocketAddress(WebSocket var1);
}

