/*
 * Decompiled with CFR 0.152.
 */
package com.testor.xxl.job.task.module.job.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSON;
import com.testor.xxl.job.task.config.XxlJobProperties;
import com.testor.xxl.job.task.exception.BizException;
import com.testor.xxl.job.task.module.job.model.BaseXxlJobApiRequest;
import com.testor.xxl.job.task.module.job.model.BaseXxlJobRequest;
import com.testor.xxl.job.task.module.job.model.CookieGetRequest;
import com.testor.xxl.job.task.module.job.service.XxlJobService;
import com.testor.xxl.job.task.response.ListGetResponse;
import com.testor.xxl.job.task.response.ReturnT;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class XxlJobServiceImpl
implements XxlJobService {
    private static final Logger log = LoggerFactory.getLogger(XxlJobServiceImpl.class);
    @Autowired
    private XxlJobProperties xxlJobProperties;
    private static final List<String> UNCHECK_RESULT_API = new ArrayList<String>();

    @Override
    public ReturnT execute(BaseXxlJobRequest request) throws BizException {
        request.check();
        String uri = request.getUrl();
        log.info("\u8bf7\u6c42xxl-job api,url\uff1a{},req\uff1a{}", (Object)uri, JSON.toJSON((Object)request));
        String resultBody = HttpRequest.post((String)(this.xxlJobProperties.getAdminAddresses() + uri)).form(request.toParamMap()).cookie(this.getCookie()).execute().body();
        log.info("xxl-job api\u54cd\u5e94,url\uff1a{},result\uff1a{}", (Object)uri, (Object)resultBody);
        if (UNCHECK_RESULT_API.contains(uri)) {
            ListGetResponse groupPageList = (ListGetResponse)JSON.parseObject((String)resultBody, ListGetResponse.class);
            ReturnT<ListGetResponse> response = new ReturnT<ListGetResponse>();
            response.setCode(200);
            response.setContent(groupPageList);
            return response;
        }
        ReturnT response = (ReturnT)JSON.parseObject((String)resultBody, ReturnT.class);
        if ("200".equals(response.getCode())) {
            log.error("xxl-job api[{}]\u6267\u884c\u5931\u8d25,result\uff1a{}", (Object)uri, JSON.toJSON((Object)response));
            throw new BizException(response.getMsg());
        }
        return response;
    }

    private String getCookie() {
        CookieGetRequest request = new CookieGetRequest();
        request.setUserName(this.xxlJobProperties.getLoginUserName());
        request.setPassword(this.xxlJobProperties.getLoginPwd());
        log.debug("\u83b7\u53d6xxl cookie,req\uff1a{}", (Object)JSON.toJSONString((Object)request));
        HttpResponse response = HttpRequest.post((String)(this.xxlJobProperties.getAdminAddresses() + request.getUrl())).form(request.toParamMap()).execute();
        if (!response.isOk()) {
            log.error("\u8c03\u7528xxl\u83b7\u53d6cookie\u5931\u8d25,response\uff1a{}", (Object)JSON.toJSONString((Object)response.body()));
            throw new BizException("\u83b7\u53d6Cookie\u5931\u8d25");
        }
        List cookies = response.getCookies();
        log.debug("\u83b7\u53d6xxl cookie\u6210\u529f,cookies\uff1a{}", (Object)JSON.toJSONString((Object)cookies));
        StringBuilder sb = new StringBuilder();
        cookies.stream().forEach(cookie -> sb.append(cookie.toString()));
        return sb.toString();
    }

    @Override
    public ReturnT execute(BaseXxlJobApiRequest request) {
        request.check();
        String uri = request.getUrl();
        log.info("\u8bf7\u6c42xxl-job \u5f00\u653eapi,url\uff1a{},req\uff1a{}", (Object)uri, JSON.toJSON((Object)request));
        String resultBody = ((HttpRequest)HttpRequest.post((String)(this.xxlJobProperties.getAdminAddresses() + uri)).body(JSON.toJSONString((Object)request)).header("XXL-JOB-ACCESS-TOKEN", this.xxlJobProperties.getAccessToken())).execute().body();
        log.info("xxl-job \u5f00\u653eapi\u54cd\u5e94,url\uff1a{},result\uff1a{}", (Object)uri, (Object)resultBody);
        ReturnT response = (ReturnT)JSON.parseObject((String)resultBody, ReturnT.class);
        if ("200".equals(response.getCode())) {
            log.error("xxl-job \u5f00\u653eapi[{}]\u6267\u884c\u5931\u8d25,result\uff1a{}", (Object)uri, JSON.toJSON((Object)response));
            throw new BizException(response.getMsg());
        }
        return response;
    }

    static {
        UNCHECK_RESULT_API.add("/jobgroup/pageList");
        UNCHECK_RESULT_API.add("/jobinfo/pageList");
    }
}

